/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.utils;

import com.docusign.iam.sdk.utils.BackoffStrategy;
import com.docusign.iam.sdk.utils.RetryConfig;
import com.docusign.iam.sdk.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class Retries {
    private final Callable<HttpResponse<InputStream>> action;
    private final RetryConfig retryConfig;
    private final List<String> statusCodes;

    private Retries(Callable<HttpResponse<InputStream>> action, RetryConfig retryConfig, List<String> statusCodes) {
        Utils.checkNotNull(action, "action");
        Utils.checkNotNull(retryConfig, "retryConfig");
        Utils.checkNotNull(statusCodes, "statusCodes");
        if (statusCodes.size() == 0) {
            throw new IllegalArgumentException("statusCodes list cannot be empty");
        }
        this.action = action;
        this.retryConfig = retryConfig;
        this.statusCodes = statusCodes;
    }

    public HttpResponse<InputStream> run() throws Exception {
        switch (this.retryConfig.strategy()) {
            case BACKOFF: {
                if (!this.retryConfig.backoff().isPresent()) {
                    throw new IllegalArgumentException("Backoff strategy is not defined");
                }
                BackoffStrategy backoff = this.retryConfig.backoff().get();
                return this.retryWithBackoff(backoff.retryConnectError(), backoff.retryReadTimeoutError());
            }
            case NONE: {
                return this.action.call();
            }
        }
        throw new IllegalArgumentException("Invalid retry strategy");
    }

    private HttpResponse<InputStream> getResponse(boolean retryConnectError, boolean retryReadTimeoutError) throws Exception {
        try {
            HttpResponse<InputStream> response = this.action.call();
            for (String statusCode : this.statusCodes) {
                int code;
                int statusMajor;
                int codeRange;
                if (!(statusCode.toUpperCase().contains("X") ? (codeRange = Integer.parseInt(statusCode.substring(0, 1))) == (statusMajor = response.statusCode() / 100) : (code = Integer.parseInt(statusCode)) == response.statusCode())) continue;
                throw new RetryableException(response);
            }
            return response;
        }
        catch (IOException e) {
            if (e instanceof ConnectException && retryConnectError) {
                throw e;
            }
            String message = e.getMessage();
            if (message != null) {
                if (message.contains("Connect timed out") && retryConnectError) {
                    throw e;
                }
                if (message.contains("Read timed out") && retryReadTimeoutError) {
                    throw e;
                }
            }
            throw new NonRetryableException(e);
        }
        catch (RetryableException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NonRetryableException(e);
        }
    }

    private HttpResponse<InputStream> retryWithBackoff(boolean retryConnectError, boolean retryReadTimeoutError) throws Exception {
        BackoffStrategy backoff = this.retryConfig.backoff().get();
        long initialIntervalMs = backoff.initialIntervalMs();
        long startMs = System.currentTimeMillis();
        int numAttempts = 0;
        while (true) {
            try {
                return this.getResponse(retryConnectError, retryReadTimeoutError);
            }
            catch (NonRetryableException e) {
                throw e.exception();
            }
            catch (RetryableException | IOException e) {
                double maxIntervalMs;
                long nowMs = System.currentTimeMillis();
                if (nowMs - startMs > backoff.maxElapsedTimeMs()) {
                    if (e instanceof RetryableException) {
                        return ((RetryableException)e).response();
                    }
                    throw e;
                }
                double intervalMs = (double)initialIntervalMs * Math.pow(backoff.baseFactor(), numAttempts);
                double jitterMs = backoff.jitterFactor() * intervalMs;
                if ((intervalMs = intervalMs - jitterMs + Math.random() * (2.0 * jitterMs + 1.0)) > (maxIntervalMs = (double)backoff.maxIntervalMs())) {
                    intervalMs = maxIntervalMs;
                }
                long sleepMs = (long)intervalMs;
                TimeUnit.MILLISECONDS.sleep(sleepMs);
                ++numAttempts;
                continue;
            }
            break;
        }
    }

    public static final Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Callable<HttpResponse<InputStream>> action;
        private RetryConfig retryConfig;
        private List<String> statusCodes;

        private Builder() {
        }

        public Builder action(Callable<HttpResponse<InputStream>> action) {
            Utils.checkNotNull(action, "action");
            this.action = action;
            return this;
        }

        public Builder retryConfig(RetryConfig retryConfig) {
            Utils.checkNotNull(retryConfig, "retryConfig");
            this.retryConfig = retryConfig;
            return this;
        }

        public Builder statusCodes(List<String> statusCodes) {
            Utils.checkNotNull(statusCodes, "statusCodes");
            if (statusCodes.size() == 0) {
                throw new IllegalArgumentException("statusCodes list cannot be empty");
            }
            this.statusCodes = statusCodes;
            return this;
        }

        public Retries build() {
            return new Retries(this.action, this.retryConfig, this.statusCodes);
        }
    }

    public static final class RetryableException
    extends Exception {
        private final HttpResponse<InputStream> response;

        public RetryableException(HttpResponse<InputStream> response) {
            this.response = response;
        }

        public HttpResponse<InputStream> response() {
            return this.response;
        }
    }

    public static final class NonRetryableException
    extends Exception {
        private final Exception exception;

        public NonRetryableException(Exception exception) {
            super(exception);
            this.exception = exception;
        }

        public Exception exception() {
            return this.exception;
        }
    }
}

