/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.models.components.TriggerWorkflow;
import com.docusign.iam.sdk.models.operations.SDKMethodInterfaces;
import com.docusign.iam.sdk.models.operations.TriggerWorkflowResponse;
import com.docusign.iam.sdk.utils.Options;
import com.docusign.iam.sdk.utils.RetryConfig;
import com.docusign.iam.sdk.utils.Utils;
import java.util.Optional;

public class TriggerWorkflowRequestBuilder {
    private String accountId;
    private String workflowId;
    private TriggerWorkflow triggerWorkflow;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallTriggerWorkflow sdk;

    public TriggerWorkflowRequestBuilder(SDKMethodInterfaces.MethodCallTriggerWorkflow sdk) {
        this.sdk = sdk;
    }

    public TriggerWorkflowRequestBuilder accountId(String accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = accountId;
        return this;
    }

    public TriggerWorkflowRequestBuilder workflowId(String workflowId) {
        Utils.checkNotNull(workflowId, "workflowId");
        this.workflowId = workflowId;
        return this;
    }

    public TriggerWorkflowRequestBuilder triggerWorkflow(TriggerWorkflow triggerWorkflow) {
        Utils.checkNotNull(triggerWorkflow, "triggerWorkflow");
        this.triggerWorkflow = triggerWorkflow;
        return this;
    }

    public TriggerWorkflowRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public TriggerWorkflowRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public TriggerWorkflowResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.triggerWorkflow(this.accountId, this.workflowId, this.triggerWorkflow, options);
    }
}

