/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.models.operations.GetTokenFromJWTGrantGrantType;
import com.docusign.iam.sdk.utils.LazySingletonValue;
import com.docusign.iam.sdk.utils.SpeakeasyMetadata;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Objects;
import java.util.Optional;

public class JWTGrant {
    @SpeakeasyMetadata(value="form:name=grant_type")
    private Optional<? extends GetTokenFromJWTGrantGrantType> grantType;
    @SpeakeasyMetadata(value="form:name=assertion")
    private String assertion;

    @JsonCreator
    public JWTGrant(Optional<? extends GetTokenFromJWTGrantGrantType> grantType, String assertion) {
        Utils.checkNotNull(grantType, "grantType");
        Utils.checkNotNull(assertion, "assertion");
        this.grantType = grantType;
        this.assertion = assertion;
    }

    public JWTGrant(String assertion) {
        this(Optional.empty(), assertion);
    }

    @JsonIgnore
    public Optional<GetTokenFromJWTGrantGrantType> grantType() {
        return this.grantType;
    }

    @JsonIgnore
    public String assertion() {
        return this.assertion;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public JWTGrant withGrantType(GetTokenFromJWTGrantGrantType grantType) {
        Utils.checkNotNull(grantType, "grantType");
        this.grantType = Optional.ofNullable(grantType);
        return this;
    }

    public JWTGrant withGrantType(Optional<? extends GetTokenFromJWTGrantGrantType> grantType) {
        Utils.checkNotNull(grantType, "grantType");
        this.grantType = grantType;
        return this;
    }

    public JWTGrant withAssertion(String assertion) {
        Utils.checkNotNull(assertion, "assertion");
        this.assertion = assertion;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JWTGrant other = (JWTGrant)o;
        return Objects.deepEquals(this.grantType, other.grantType) && Objects.deepEquals(this.assertion, other.assertion);
    }

    public int hashCode() {
        return Objects.hash(this.grantType, this.assertion);
    }

    public String toString() {
        return Utils.toString(JWTGrant.class, "grantType", this.grantType, "assertion", this.assertion);
    }

    public static final class Builder {
        private Optional<? extends GetTokenFromJWTGrantGrantType> grantType;
        private String assertion;
        private static final LazySingletonValue<Optional<? extends GetTokenFromJWTGrantGrantType>> _SINGLETON_VALUE_GrantType = new LazySingletonValue<Optional<? extends GetTokenFromJWTGrantGrantType>>("grant_type", "\"urn:ietf:params:oauth:grant-type:jwt-bearer\"", new TypeReference<Optional<? extends GetTokenFromJWTGrantGrantType>>(){});

        private Builder() {
        }

        public Builder grantType(GetTokenFromJWTGrantGrantType grantType) {
            Utils.checkNotNull(grantType, "grantType");
            this.grantType = Optional.ofNullable(grantType);
            return this;
        }

        public Builder grantType(Optional<? extends GetTokenFromJWTGrantGrantType> grantType) {
            Utils.checkNotNull(grantType, "grantType");
            this.grantType = grantType;
            return this;
        }

        public Builder assertion(String assertion) {
            Utils.checkNotNull(assertion, "assertion");
            this.assertion = assertion;
            return this;
        }

        public JWTGrant build() {
            if (this.grantType == null) {
                this.grantType = _SINGLETON_VALUE_GrantType.value();
            }
            return new JWTGrant(this.grantType, this.assertion);
        }
    }
}

