/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.utils.SpeakeasyMetadata;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;

public class GetWorkflowTriggerRequirementsRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=accountId")
    private String accountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=workflowId")
    private String workflowId;

    @JsonCreator
    public GetWorkflowTriggerRequirementsRequest(String accountId, String workflowId) {
        Utils.checkNotNull(accountId, "accountId");
        Utils.checkNotNull(workflowId, "workflowId");
        this.accountId = accountId;
        this.workflowId = workflowId;
    }

    @JsonIgnore
    public String accountId() {
        return this.accountId;
    }

    @JsonIgnore
    public String workflowId() {
        return this.workflowId;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetWorkflowTriggerRequirementsRequest withAccountId(String accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = accountId;
        return this;
    }

    public GetWorkflowTriggerRequirementsRequest withWorkflowId(String workflowId) {
        Utils.checkNotNull(workflowId, "workflowId");
        this.workflowId = workflowId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetWorkflowTriggerRequirementsRequest other = (GetWorkflowTriggerRequirementsRequest)o;
        return Objects.deepEquals(this.accountId, other.accountId) && Objects.deepEquals(this.workflowId, other.workflowId);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.workflowId);
    }

    public String toString() {
        return Utils.toString(GetWorkflowTriggerRequirementsRequest.class, "accountId", this.accountId, "workflowId", this.workflowId);
    }

    public static final class Builder {
        private String accountId;
        private String workflowId;

        private Builder() {
        }

        public Builder accountId(String accountId) {
            Utils.checkNotNull(accountId, "accountId");
            this.accountId = accountId;
            return this;
        }

        public Builder workflowId(String workflowId) {
            Utils.checkNotNull(workflowId, "workflowId");
            this.workflowId = workflowId;
            return this;
        }

        public GetWorkflowTriggerRequirementsRequest build() {
            return new GetWorkflowTriggerRequirementsRequest(this.accountId, this.workflowId);
        }
    }
}

