/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.utils.SpeakeasyMetadata;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;

public class GetWorkflowInstanceRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=accountId")
    private String accountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=workflowId")
    private String workflowId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=instanceId")
    private String instanceId;

    @JsonCreator
    public GetWorkflowInstanceRequest(String accountId, String workflowId, String instanceId) {
        Utils.checkNotNull(accountId, "accountId");
        Utils.checkNotNull(workflowId, "workflowId");
        Utils.checkNotNull(instanceId, "instanceId");
        this.accountId = accountId;
        this.workflowId = workflowId;
        this.instanceId = instanceId;
    }

    @JsonIgnore
    public String accountId() {
        return this.accountId;
    }

    @JsonIgnore
    public String workflowId() {
        return this.workflowId;
    }

    @JsonIgnore
    public String instanceId() {
        return this.instanceId;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetWorkflowInstanceRequest withAccountId(String accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = accountId;
        return this;
    }

    public GetWorkflowInstanceRequest withWorkflowId(String workflowId) {
        Utils.checkNotNull(workflowId, "workflowId");
        this.workflowId = workflowId;
        return this;
    }

    public GetWorkflowInstanceRequest withInstanceId(String instanceId) {
        Utils.checkNotNull(instanceId, "instanceId");
        this.instanceId = instanceId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetWorkflowInstanceRequest other = (GetWorkflowInstanceRequest)o;
        return Objects.deepEquals(this.accountId, other.accountId) && Objects.deepEquals(this.workflowId, other.workflowId) && Objects.deepEquals(this.instanceId, other.instanceId);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.workflowId, this.instanceId);
    }

    public String toString() {
        return Utils.toString(GetWorkflowInstanceRequest.class, "accountId", this.accountId, "workflowId", this.workflowId, "instanceId", this.instanceId);
    }

    public static final class Builder {
        private String accountId;
        private String workflowId;
        private String instanceId;

        private Builder() {
        }

        public Builder accountId(String accountId) {
            Utils.checkNotNull(accountId, "accountId");
            this.accountId = accountId;
            return this;
        }

        public Builder workflowId(String workflowId) {
            Utils.checkNotNull(workflowId, "workflowId");
            this.workflowId = workflowId;
            return this;
        }

        public Builder instanceId(String instanceId) {
            Utils.checkNotNull(instanceId, "instanceId");
            this.instanceId = instanceId;
            return this;
        }

        public GetWorkflowInstanceRequest build() {
            return new GetWorkflowInstanceRequest(this.accountId, this.workflowId, this.instanceId);
        }
    }
}

