/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.models.components.UserInfo;
import com.docusign.iam.sdk.utils.Response;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class GetUserInfoResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends UserInfo> userInfo;

    @JsonCreator
    public GetUserInfoResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends UserInfo> userInfo) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(userInfo, "userInfo");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.userInfo = userInfo;
    }

    public GetUserInfoResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<UserInfo> userInfo() {
        return this.userInfo;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetUserInfoResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public GetUserInfoResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public GetUserInfoResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public GetUserInfoResponse withUserInfo(UserInfo userInfo) {
        Utils.checkNotNull(userInfo, "userInfo");
        this.userInfo = Optional.ofNullable(userInfo);
        return this;
    }

    public GetUserInfoResponse withUserInfo(Optional<? extends UserInfo> userInfo) {
        Utils.checkNotNull(userInfo, "userInfo");
        this.userInfo = userInfo;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetUserInfoResponse other = (GetUserInfoResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.userInfo, other.userInfo);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.userInfo);
    }

    public String toString() {
        return Utils.toString(GetUserInfoResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "userInfo", this.userInfo);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends UserInfo> userInfo = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder userInfo(UserInfo userInfo) {
            Utils.checkNotNull(userInfo, "userInfo");
            this.userInfo = Optional.ofNullable(userInfo);
            return this;
        }

        public Builder userInfo(Optional<? extends UserInfo> userInfo) {
            Utils.checkNotNull(userInfo, "userInfo");
            this.userInfo = userInfo;
            return this;
        }

        public GetUserInfoResponse build() {
            return new GetUserInfoResponse(this.contentType, this.statusCode, this.rawResponse, this.userInfo);
        }
    }
}

