/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.models.components.PublicAuthCodeGrantRequestBody;
import com.docusign.iam.sdk.models.operations.GetTokenFromPublicAuthCodeResponse;
import com.docusign.iam.sdk.models.operations.SDKMethodInterfaces;
import com.docusign.iam.sdk.utils.Options;
import com.docusign.iam.sdk.utils.RetryConfig;
import com.docusign.iam.sdk.utils.Utils;
import java.util.Optional;

public class GetTokenFromPublicAuthCodeRequestBuilder {
    private PublicAuthCodeGrantRequestBody request;
    private Optional<String> serverURL = Optional.empty();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallGetTokenFromPublicAuthCode sdk;

    public GetTokenFromPublicAuthCodeRequestBuilder(SDKMethodInterfaces.MethodCallGetTokenFromPublicAuthCode sdk) {
        this.sdk = sdk;
    }

    public GetTokenFromPublicAuthCodeRequestBuilder request(PublicAuthCodeGrantRequestBody request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public GetTokenFromPublicAuthCodeRequestBuilder serverURL(String serverURL) {
        Utils.checkNotNull(serverURL, "serverURL");
        this.serverURL = Optional.of(serverURL);
        return this;
    }

    public GetTokenFromPublicAuthCodeRequestBuilder serverURL(Optional<String> serverURL) {
        Utils.checkNotNull(serverURL, "serverURL");
        this.serverURL = serverURL;
        return this;
    }

    public GetTokenFromPublicAuthCodeRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetTokenFromPublicAuthCodeRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public GetTokenFromPublicAuthCodeResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.getTokenFromPublicAuthCode(this.request, this.serverURL, options);
    }
}

