/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.utils.LazySingletonValue;
import com.docusign.iam.sdk.utils.SpeakeasyMetadata;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class GetAgreementsListRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=accountId")
    private Optional<String> accountId;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=limit")
    private JsonNullable<Integer> limit;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=ctoken")
    private JsonNullable<String> ctoken;

    @JsonCreator
    public GetAgreementsListRequest(Optional<String> accountId, JsonNullable<Integer> limit, JsonNullable<String> ctoken) {
        Utils.checkNotNull(accountId, "accountId");
        Utils.checkNotNull(limit, "limit");
        Utils.checkNotNull(ctoken, "ctoken");
        this.accountId = accountId;
        this.limit = limit;
        this.ctoken = ctoken;
    }

    public GetAgreementsListRequest() {
        this(Optional.empty(), (JsonNullable<Integer>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined());
    }

    @JsonIgnore
    public Optional<String> accountId() {
        return this.accountId;
    }

    @JsonIgnore
    public JsonNullable<Integer> limit() {
        return this.limit;
    }

    @JsonIgnore
    public JsonNullable<String> ctoken() {
        return this.ctoken;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetAgreementsListRequest withAccountId(String accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = Optional.ofNullable(accountId);
        return this;
    }

    public GetAgreementsListRequest withAccountId(Optional<String> accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = accountId;
        return this;
    }

    public GetAgreementsListRequest withLimit(int limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = JsonNullable.of((Object)limit);
        return this;
    }

    public GetAgreementsListRequest withLimit(JsonNullable<Integer> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public GetAgreementsListRequest withCtoken(String ctoken) {
        Utils.checkNotNull(ctoken, "ctoken");
        this.ctoken = JsonNullable.of((Object)ctoken);
        return this;
    }

    public GetAgreementsListRequest withCtoken(JsonNullable<String> ctoken) {
        Utils.checkNotNull(ctoken, "ctoken");
        this.ctoken = ctoken;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetAgreementsListRequest other = (GetAgreementsListRequest)o;
        return Objects.deepEquals(this.accountId, other.accountId) && Objects.deepEquals(this.limit, other.limit) && Objects.deepEquals(this.ctoken, other.ctoken);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.limit, this.ctoken);
    }

    public String toString() {
        return Utils.toString(GetAgreementsListRequest.class, "accountId", this.accountId, "limit", this.limit, "ctoken", this.ctoken);
    }

    public static final class Builder {
        private Optional<String> accountId;
        private JsonNullable<Integer> limit = JsonNullable.undefined();
        private JsonNullable<String> ctoken = JsonNullable.undefined();
        private static final LazySingletonValue<Optional<String>> _SINGLETON_VALUE_AccountId = new LazySingletonValue<Optional<String>>("accountId", "\"00000000-0000-0000-0000-000000000000\"", new TypeReference<Optional<String>>(){});

        private Builder() {
        }

        public Builder accountId(String accountId) {
            Utils.checkNotNull(accountId, "accountId");
            this.accountId = Optional.ofNullable(accountId);
            return this;
        }

        public Builder accountId(Optional<String> accountId) {
            Utils.checkNotNull(accountId, "accountId");
            this.accountId = accountId;
            return this;
        }

        public Builder limit(int limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = JsonNullable.of((Object)limit);
            return this;
        }

        public Builder limit(JsonNullable<Integer> limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = limit;
            return this;
        }

        public Builder ctoken(String ctoken) {
            Utils.checkNotNull(ctoken, "ctoken");
            this.ctoken = JsonNullable.of((Object)ctoken);
            return this;
        }

        public Builder ctoken(JsonNullable<String> ctoken) {
            Utils.checkNotNull(ctoken, "ctoken");
            this.ctoken = ctoken;
            return this;
        }

        public GetAgreementsListRequest build() {
            if (this.accountId == null) {
                this.accountId = _SINGLETON_VALUE_AccountId.value();
            }
            return new GetAgreementsListRequest(this.accountId, this.limit, this.ctoken);
        }
    }
}

