/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.errors;

import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class OAuthErrorResponse
extends RuntimeException {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="error")
    private JsonNullable<String> error;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="error_description")
    private JsonNullable<String> errorDescription;

    @JsonCreator
    public OAuthErrorResponse(@JsonProperty(value="error") JsonNullable<String> error, @JsonProperty(value="error_description") JsonNullable<String> errorDescription) {
        Utils.checkNotNull(error, "error");
        Utils.checkNotNull(errorDescription, "errorDescription");
        this.error = error;
        this.errorDescription = errorDescription;
    }

    public OAuthErrorResponse() {
        this((JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<String> error() {
        return this.error;
    }

    @JsonIgnore
    public JsonNullable<String> errorDescription() {
        return this.errorDescription;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public OAuthErrorResponse withError(String error) {
        Utils.checkNotNull(error, "error");
        this.error = JsonNullable.of((Object)error);
        return this;
    }

    public OAuthErrorResponse withError(JsonNullable<String> error) {
        Utils.checkNotNull(error, "error");
        this.error = error;
        return this;
    }

    public OAuthErrorResponse withErrorDescription(String errorDescription) {
        Utils.checkNotNull(errorDescription, "errorDescription");
        this.errorDescription = JsonNullable.of((Object)errorDescription);
        return this;
    }

    public OAuthErrorResponse withErrorDescription(JsonNullable<String> errorDescription) {
        Utils.checkNotNull(errorDescription, "errorDescription");
        this.errorDescription = errorDescription;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthErrorResponse other = (OAuthErrorResponse)o;
        return Objects.deepEquals(this.error, other.error) && Objects.deepEquals(this.errorDescription, other.errorDescription);
    }

    public int hashCode() {
        return Objects.hash(this.error, this.errorDescription);
    }

    @Override
    public String toString() {
        return Utils.toString(OAuthErrorResponse.class, "error", this.error, "errorDescription", this.errorDescription);
    }

    public static final class Builder {
        private JsonNullable<String> error = JsonNullable.undefined();
        private JsonNullable<String> errorDescription = JsonNullable.undefined();

        private Builder() {
        }

        public Builder error(String error) {
            Utils.checkNotNull(error, "error");
            this.error = JsonNullable.of((Object)error);
            return this;
        }

        public Builder error(JsonNullable<String> error) {
            Utils.checkNotNull(error, "error");
            this.error = error;
            return this;
        }

        public Builder errorDescription(String errorDescription) {
            Utils.checkNotNull(errorDescription, "errorDescription");
            this.errorDescription = JsonNullable.of((Object)errorDescription);
            return this;
        }

        public Builder errorDescription(JsonNullable<String> errorDescription) {
            Utils.checkNotNull(errorDescription, "errorDescription");
            this.errorDescription = errorDescription;
            return this;
        }

        public OAuthErrorResponse build() {
            return new OAuthErrorResponse(this.error, this.errorDescription);
        }
    }
}

