/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.errors;

import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;

public class Error
extends RuntimeException {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="error")
    private Optional<String> error;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="code")
    private Optional<Long> code;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="timestamp")
    private Optional<OffsetDateTime> timestamp;

    @JsonCreator
    public Error(@JsonProperty(value="error") Optional<String> error, @JsonProperty(value="code") Optional<Long> code, @JsonProperty(value="timestamp") Optional<OffsetDateTime> timestamp) {
        Utils.checkNotNull(error, "error");
        Utils.checkNotNull(code, "code");
        Utils.checkNotNull(timestamp, "timestamp");
        this.error = error;
        this.code = code;
        this.timestamp = timestamp;
    }

    public Error() {
        this(Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> error() {
        return this.error;
    }

    @JsonIgnore
    public Optional<Long> code() {
        return this.code;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> timestamp() {
        return this.timestamp;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Error withError(String error) {
        Utils.checkNotNull(error, "error");
        this.error = Optional.ofNullable(error);
        return this;
    }

    public Error withError(Optional<String> error) {
        Utils.checkNotNull(error, "error");
        this.error = error;
        return this;
    }

    public Error withCode(long code) {
        Utils.checkNotNull(code, "code");
        this.code = Optional.ofNullable(code);
        return this;
    }

    public Error withCode(Optional<Long> code) {
        Utils.checkNotNull(code, "code");
        this.code = code;
        return this;
    }

    public Error withTimestamp(OffsetDateTime timestamp) {
        Utils.checkNotNull(timestamp, "timestamp");
        this.timestamp = Optional.ofNullable(timestamp);
        return this;
    }

    public Error withTimestamp(Optional<OffsetDateTime> timestamp) {
        Utils.checkNotNull(timestamp, "timestamp");
        this.timestamp = timestamp;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error other = (Error)o;
        return Objects.deepEquals(this.error, other.error) && Objects.deepEquals(this.code, other.code) && Objects.deepEquals(this.timestamp, other.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.error, this.code, this.timestamp);
    }

    @Override
    public String toString() {
        return Utils.toString(Error.class, "error", this.error, "code", this.code, "timestamp", this.timestamp);
    }

    public static final class Builder {
        private Optional<String> error = Optional.empty();
        private Optional<Long> code = Optional.empty();
        private Optional<OffsetDateTime> timestamp = Optional.empty();

        private Builder() {
        }

        public Builder error(String error) {
            Utils.checkNotNull(error, "error");
            this.error = Optional.ofNullable(error);
            return this;
        }

        public Builder error(Optional<String> error) {
            Utils.checkNotNull(error, "error");
            this.error = error;
            return this;
        }

        public Builder code(long code) {
            Utils.checkNotNull(code, "code");
            this.code = Optional.ofNullable(code);
            return this;
        }

        public Builder code(Optional<Long> code) {
            Utils.checkNotNull(code, "code");
            this.code = code;
            return this;
        }

        public Builder timestamp(OffsetDateTime timestamp) {
            Utils.checkNotNull(timestamp, "timestamp");
            this.timestamp = Optional.ofNullable(timestamp);
            return this;
        }

        public Builder timestamp(Optional<OffsetDateTime> timestamp) {
            Utils.checkNotNull(timestamp, "timestamp");
            this.timestamp = timestamp;
            return this;
        }

        public Error build() {
            return new Error(this.error, this.code, this.timestamp);
        }
    }
}

