/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.models.components.ResponseMetadata;
import com.docusign.iam.sdk.models.components.WorkflowList;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class WorkflowsListSuccess {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="data")
    private Optional<? extends WorkflowList> data;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="response_metadata")
    private Optional<? extends ResponseMetadata> responseMetadata;

    @JsonCreator
    public WorkflowsListSuccess(@JsonProperty(value="data") Optional<? extends WorkflowList> data, @JsonProperty(value="response_metadata") Optional<? extends ResponseMetadata> responseMetadata) {
        Utils.checkNotNull(data, "data");
        Utils.checkNotNull(responseMetadata, "responseMetadata");
        this.data = data;
        this.responseMetadata = responseMetadata;
    }

    public WorkflowsListSuccess() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<WorkflowList> data() {
        return this.data;
    }

    @JsonIgnore
    public Optional<ResponseMetadata> responseMetadata() {
        return this.responseMetadata;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public WorkflowsListSuccess withData(WorkflowList data) {
        Utils.checkNotNull(data, "data");
        this.data = Optional.ofNullable(data);
        return this;
    }

    public WorkflowsListSuccess withData(Optional<? extends WorkflowList> data) {
        Utils.checkNotNull(data, "data");
        this.data = data;
        return this;
    }

    public WorkflowsListSuccess withResponseMetadata(ResponseMetadata responseMetadata) {
        Utils.checkNotNull(responseMetadata, "responseMetadata");
        this.responseMetadata = Optional.ofNullable(responseMetadata);
        return this;
    }

    public WorkflowsListSuccess withResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
        Utils.checkNotNull(responseMetadata, "responseMetadata");
        this.responseMetadata = responseMetadata;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowsListSuccess other = (WorkflowsListSuccess)o;
        return Objects.deepEquals(this.data, other.data) && Objects.deepEquals(this.responseMetadata, other.responseMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.responseMetadata);
    }

    public String toString() {
        return Utils.toString(WorkflowsListSuccess.class, "data", this.data, "responseMetadata", this.responseMetadata);
    }

    public static final class Builder {
        private Optional<? extends WorkflowList> data = Optional.empty();
        private Optional<? extends ResponseMetadata> responseMetadata = Optional.empty();

        private Builder() {
        }

        public Builder data(WorkflowList data) {
            Utils.checkNotNull(data, "data");
            this.data = Optional.ofNullable(data);
            return this;
        }

        public Builder data(Optional<? extends WorkflowList> data) {
            Utils.checkNotNull(data, "data");
            this.data = data;
            return this;
        }

        public Builder responseMetadata(ResponseMetadata responseMetadata) {
            Utils.checkNotNull(responseMetadata, "responseMetadata");
            this.responseMetadata = Optional.ofNullable(responseMetadata);
            return this;
        }

        public Builder responseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            Utils.checkNotNull(responseMetadata, "responseMetadata");
            this.responseMetadata = responseMetadata;
            return this;
        }

        public WorkflowsListSuccess build() {
            return new WorkflowsListSuccess(this.data, this.responseMetadata);
        }
    }
}

