/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class TabConnectionInstance {
    @JsonProperty(value="connectionKey")
    private String connectionKey;
    @JsonProperty(value="connectionValue")
    private String connectionValue;

    @JsonCreator
    public TabConnectionInstance(@JsonProperty(value="connectionKey") String connectionKey, @JsonProperty(value="connectionValue") String connectionValue) {
        Utils.checkNotNull(connectionKey, "connectionKey");
        Utils.checkNotNull(connectionValue, "connectionValue");
        this.connectionKey = connectionKey;
        this.connectionValue = connectionValue;
    }

    @JsonIgnore
    public String connectionKey() {
        return this.connectionKey;
    }

    @JsonIgnore
    public String connectionValue() {
        return this.connectionValue;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public TabConnectionInstance withConnectionKey(String connectionKey) {
        Utils.checkNotNull(connectionKey, "connectionKey");
        this.connectionKey = connectionKey;
        return this;
    }

    public TabConnectionInstance withConnectionValue(String connectionValue) {
        Utils.checkNotNull(connectionValue, "connectionValue");
        this.connectionValue = connectionValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TabConnectionInstance other = (TabConnectionInstance)o;
        return Objects.deepEquals(this.connectionKey, other.connectionKey) && Objects.deepEquals(this.connectionValue, other.connectionValue);
    }

    public int hashCode() {
        return Objects.hash(this.connectionKey, this.connectionValue);
    }

    public String toString() {
        return Utils.toString(TabConnectionInstance.class, "connectionKey", this.connectionKey, "connectionValue", this.connectionValue);
    }

    public static final class Builder {
        private String connectionKey;
        private String connectionValue;

        private Builder() {
        }

        public Builder connectionKey(String connectionKey) {
            Utils.checkNotNull(connectionKey, "connectionKey");
            this.connectionKey = connectionKey;
            return this;
        }

        public Builder connectionValue(String connectionValue) {
            Utils.checkNotNull(connectionValue, "connectionValue");
            this.connectionValue = connectionValue;
            return this;
        }

        public TabConnectionInstance build() {
            return new TabConnectionInstance(this.connectionKey, this.connectionValue);
        }
    }
}

