/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.utils.HasSecurity;
import com.docusign.iam.sdk.utils.SpeakeasyMetadata;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.Optional;

public class Security
implements HasSecurity {
    @SpeakeasyMetadata(value="security:scheme=true,type=oauth2,name=Authorization")
    private Optional<String> accessToken;

    @JsonCreator
    public Security(Optional<String> accessToken) {
        Utils.checkNotNull(accessToken, "accessToken");
        this.accessToken = accessToken;
    }

    public Security() {
        this(Optional.empty());
    }

    @JsonIgnore
    public Optional<String> accessToken() {
        return this.accessToken;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Security withAccessToken(String accessToken) {
        Utils.checkNotNull(accessToken, "accessToken");
        this.accessToken = Optional.ofNullable(accessToken);
        return this;
    }

    public Security withAccessToken(Optional<String> accessToken) {
        Utils.checkNotNull(accessToken, "accessToken");
        this.accessToken = accessToken;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Security other = (Security)o;
        return Objects.deepEquals(this.accessToken, other.accessToken);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken);
    }

    public String toString() {
        return Utils.toString(Security.class, "accessToken", this.accessToken);
    }

    public static final class Builder {
        private Optional<String> accessToken = Optional.empty();

        private Builder() {
        }

        public Builder accessToken(String accessToken) {
            Utils.checkNotNull(accessToken, "accessToken");
            this.accessToken = Optional.ofNullable(accessToken);
            return this;
        }

        public Builder accessToken(Optional<String> accessToken) {
            Utils.checkNotNull(accessToken, "accessToken");
            this.accessToken = accessToken;
            return this;
        }

        public Security build() {
            return new Security(this.accessToken);
        }
    }
}

