/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.models.components.PublicAuthCodeGrantRequestBodyGrantType;
import com.docusign.iam.sdk.utils.LazySingletonValue;
import com.docusign.iam.sdk.utils.SpeakeasyMetadata;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Objects;
import java.util.Optional;

public class PublicAuthCodeGrantRequestBody {
    @SpeakeasyMetadata(value="form:name=grant_type")
    private Optional<? extends PublicAuthCodeGrantRequestBodyGrantType> grantType;
    @SpeakeasyMetadata(value="form:name=client_id")
    private String clientId;
    @SpeakeasyMetadata(value="form:name=code")
    private String code;
    @SpeakeasyMetadata(value="form:name=code_verifier")
    private String codeVerifier;

    @JsonCreator
    public PublicAuthCodeGrantRequestBody(Optional<? extends PublicAuthCodeGrantRequestBodyGrantType> grantType, String clientId, String code, String codeVerifier) {
        Utils.checkNotNull(grantType, "grantType");
        Utils.checkNotNull(clientId, "clientId");
        Utils.checkNotNull(code, "code");
        Utils.checkNotNull(codeVerifier, "codeVerifier");
        this.grantType = grantType;
        this.clientId = clientId;
        this.code = code;
        this.codeVerifier = codeVerifier;
    }

    public PublicAuthCodeGrantRequestBody(String clientId, String code, String codeVerifier) {
        this(Optional.empty(), clientId, code, codeVerifier);
    }

    @JsonIgnore
    public Optional<PublicAuthCodeGrantRequestBodyGrantType> grantType() {
        return this.grantType;
    }

    @JsonIgnore
    public String clientId() {
        return this.clientId;
    }

    @JsonIgnore
    public String code() {
        return this.code;
    }

    @JsonIgnore
    public String codeVerifier() {
        return this.codeVerifier;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public PublicAuthCodeGrantRequestBody withGrantType(PublicAuthCodeGrantRequestBodyGrantType grantType) {
        Utils.checkNotNull(grantType, "grantType");
        this.grantType = Optional.ofNullable(grantType);
        return this;
    }

    public PublicAuthCodeGrantRequestBody withGrantType(Optional<? extends PublicAuthCodeGrantRequestBodyGrantType> grantType) {
        Utils.checkNotNull(grantType, "grantType");
        this.grantType = grantType;
        return this;
    }

    public PublicAuthCodeGrantRequestBody withClientId(String clientId) {
        Utils.checkNotNull(clientId, "clientId");
        this.clientId = clientId;
        return this;
    }

    public PublicAuthCodeGrantRequestBody withCode(String code) {
        Utils.checkNotNull(code, "code");
        this.code = code;
        return this;
    }

    public PublicAuthCodeGrantRequestBody withCodeVerifier(String codeVerifier) {
        Utils.checkNotNull(codeVerifier, "codeVerifier");
        this.codeVerifier = codeVerifier;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicAuthCodeGrantRequestBody other = (PublicAuthCodeGrantRequestBody)o;
        return Objects.deepEquals(this.grantType, other.grantType) && Objects.deepEquals(this.clientId, other.clientId) && Objects.deepEquals(this.code, other.code) && Objects.deepEquals(this.codeVerifier, other.codeVerifier);
    }

    public int hashCode() {
        return Objects.hash(this.grantType, this.clientId, this.code, this.codeVerifier);
    }

    public String toString() {
        return Utils.toString(PublicAuthCodeGrantRequestBody.class, "grantType", this.grantType, "clientId", this.clientId, "code", this.code, "codeVerifier", this.codeVerifier);
    }

    public static final class Builder {
        private Optional<? extends PublicAuthCodeGrantRequestBodyGrantType> grantType;
        private String clientId;
        private String code;
        private String codeVerifier;
        private static final LazySingletonValue<Optional<? extends PublicAuthCodeGrantRequestBodyGrantType>> _SINGLETON_VALUE_GrantType = new LazySingletonValue<Optional<? extends PublicAuthCodeGrantRequestBodyGrantType>>("grant_type", "\"authorization_code\"", new TypeReference<Optional<? extends PublicAuthCodeGrantRequestBodyGrantType>>(){});

        private Builder() {
        }

        public Builder grantType(PublicAuthCodeGrantRequestBodyGrantType grantType) {
            Utils.checkNotNull(grantType, "grantType");
            this.grantType = Optional.ofNullable(grantType);
            return this;
        }

        public Builder grantType(Optional<? extends PublicAuthCodeGrantRequestBodyGrantType> grantType) {
            Utils.checkNotNull(grantType, "grantType");
            this.grantType = grantType;
            return this;
        }

        public Builder clientId(String clientId) {
            Utils.checkNotNull(clientId, "clientId");
            this.clientId = clientId;
            return this;
        }

        public Builder code(String code) {
            Utils.checkNotNull(code, "code");
            this.code = code;
            return this;
        }

        public Builder codeVerifier(String codeVerifier) {
            Utils.checkNotNull(codeVerifier, "codeVerifier");
            this.codeVerifier = codeVerifier;
            return this;
        }

        public PublicAuthCodeGrantRequestBody build() {
            if (this.grantType == null) {
                this.grantType = _SINGLETON_VALUE_GrantType.value();
            }
            return new PublicAuthCodeGrantRequestBody(this.grantType, this.clientId, this.code, this.codeVerifier);
        }
    }
}

