/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.models.components.Link;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class Organization {
    @JsonProperty(value="organization_id")
    private String organizationId;
    @JsonProperty(value="links")
    private List<Link> links;

    @JsonCreator
    public Organization(@JsonProperty(value="organization_id") String organizationId, @JsonProperty(value="links") List<Link> links) {
        Utils.checkNotNull(organizationId, "organizationId");
        Utils.checkNotNull(links, "links");
        this.organizationId = organizationId;
        this.links = links;
    }

    @JsonIgnore
    public String organizationId() {
        return this.organizationId;
    }

    @JsonIgnore
    public List<Link> links() {
        return this.links;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Organization withOrganizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public Organization withLinks(List<Link> links) {
        Utils.checkNotNull(links, "links");
        this.links = links;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Organization other = (Organization)o;
        return Objects.deepEquals(this.organizationId, other.organizationId) && Objects.deepEquals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.organizationId, this.links);
    }

    public String toString() {
        return Utils.toString(Organization.class, "organizationId", this.organizationId, "links", this.links);
    }

    public static final class Builder {
        private String organizationId;
        private List<Link> links;

        private Builder() {
        }

        public Builder organizationId(String organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = organizationId;
            return this;
        }

        public Builder links(List<Link> links) {
            Utils.checkNotNull(links, "links");
            this.links = links;
            return this;
        }

        public Organization build() {
            return new Organization(this.organizationId, this.links);
        }
    }
}

