/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk;

import com.docusign.iam.sdk.SDKConfiguration;
import com.docusign.iam.sdk.SecuritySource;
import com.docusign.iam.sdk.models.errors.APIException;
import com.docusign.iam.sdk.models.operations.ConnectedFieldsApiGetTabGroupsRequest;
import com.docusign.iam.sdk.models.operations.ConnectedFieldsApiGetTabGroupsRequestBuilder;
import com.docusign.iam.sdk.models.operations.ConnectedFieldsApiGetTabGroupsResponse;
import com.docusign.iam.sdk.models.operations.SDKMethodInterfaces;
import com.docusign.iam.sdk.utils.BackoffStrategy;
import com.docusign.iam.sdk.utils.HTTPClient;
import com.docusign.iam.sdk.utils.HTTPRequest;
import com.docusign.iam.sdk.utils.Hook;
import com.docusign.iam.sdk.utils.Options;
import com.docusign.iam.sdk.utils.Retries;
import com.docusign.iam.sdk.utils.RetryConfig;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class TabInfo
implements SDKMethodInterfaces.MethodCallConnectedFieldsApiGetTabGroups {
    private final SDKConfiguration sdkConfiguration;

    TabInfo(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public ConnectedFieldsApiGetTabGroupsRequestBuilder getConnectedFieldsTabGroups() {
        return new ConnectedFieldsApiGetTabGroupsRequestBuilder(this);
    }

    public ConnectedFieldsApiGetTabGroupsResponse getConnectedFieldsTabGroups(String accountId) throws Exception {
        return this.getConnectedFieldsTabGroups(accountId, Optional.empty(), Optional.empty());
    }

    @Override
    public ConnectedFieldsApiGetTabGroupsResponse getConnectedFieldsTabGroups(String accountId, Optional<String> appId, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        ConnectedFieldsApiGetTabGroupsRequest request = ConnectedFieldsApiGetTabGroupsRequest.builder().accountId(accountId).appId(appId).build();
        String _baseUrl = this.sdkConfiguration.serverUrl();
        String _url = Utils.generateURL(ConnectedFieldsApiGetTabGroupsRequest.class, _baseUrl, "/accounts/{accountId}/connected-fields/tab-groups", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        _req.addQueryParams(Utils.getQueryParams(ConnectedFieldsApiGetTabGroupsRequest.class, request, null));
        Optional<SecuritySource> _hookSecuritySource = Optional.of(this.sdkConfiguration.securitySource());
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource().getSecurity());
        HTTPClient _client = this.sdkConfiguration.client();
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig().isPresent() ? this.sdkConfiguration.retryConfig().get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(5000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(30000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        _statusCodes.add("429");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(this.sdkConfiguration, _baseUrl, "ConnectedFieldsApi_GetTabGroups", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(this.sdkConfiguration, _baseUrl, "ConnectedFieldsApi_GetTabGroups", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(this.sdkConfiguration, _baseUrl, "ConnectedFieldsApi_GetTabGroups", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        ConnectedFieldsApiGetTabGroupsResponse.Builder _resBuilder = ConnectedFieldsApiGetTabGroupsResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        ConnectedFieldsApiGetTabGroupsResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                List _out = (List)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<List<com.docusign.iam.sdk.models.components.TabInfo>>(){});
                _res.withTabInfos(Optional.ofNullable(_out));
                return _res;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "401", "4XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }
}

