/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk;

import com.docusign.iam.sdk.Auth;
import com.docusign.iam.sdk.ConnectedFields;
import com.docusign.iam.sdk.Maestro;
import com.docusign.iam.sdk.Navigator;
import com.docusign.iam.sdk.SDKConfiguration;
import com.docusign.iam.sdk.SecuritySource;
import com.docusign.iam.sdk.models.components.Security;
import com.docusign.iam.sdk.utils.HTTPClient;
import com.docusign.iam.sdk.utils.Hooks;
import com.docusign.iam.sdk.utils.RetryConfig;
import com.docusign.iam.sdk.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

public class IamClient {
    public static final Map<AvailableServers, String> SERVERS = new HashMap<AvailableServers, String>(){
        {
            this.put(AvailableServers.DEMO, "https://api-d.docusign.com/v1");
            this.put(AvailableServers.PROD, "https://api.docusign.com/v1");
        }
    };
    private final Auth auth;
    private final Maestro maestro;
    private final Navigator navigator;
    private final ConnectedFields connectedFields;
    private SDKConfiguration sdkConfiguration;

    public Auth auth() {
        return this.auth;
    }

    public Maestro maestro() {
        return this.maestro;
    }

    public Navigator navigator() {
        return this.navigator;
    }

    public ConnectedFields connectedFields() {
        return this.connectedFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    private IamClient(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.sdkConfiguration.initialize();
        this.auth = new Auth(sdkConfiguration);
        this.maestro = new Maestro(sdkConfiguration);
        this.navigator = new Navigator(sdkConfiguration);
        this.connectedFields = new ConnectedFields(sdkConfiguration);
        this.sdkConfiguration = this.sdkConfiguration.hooks().sdkInit(this.sdkConfiguration);
    }

    public static class Builder {
        private final SDKConfiguration sdkConfiguration = new SDKConfiguration();
        private String serverUrl;
        private String server;

        private Builder() {
        }

        public Builder client(HTTPClient client) {
            this.sdkConfiguration.setClient(client);
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.sdkConfiguration.setSecuritySource(SecuritySource.of(Security.builder().accessToken(accessToken).build()));
            return this;
        }

        public Builder securitySource(SecuritySource securitySource) {
            Utils.checkNotNull(securitySource, "securitySource");
            this.sdkConfiguration.setSecuritySource(securitySource);
            return this;
        }

        public Builder serverURL(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public Builder serverURL(String serverUrl, Map<String, String> params) {
            this.serverUrl = Utils.templateUrl(serverUrl, params);
            return this;
        }

        public Builder server(AvailableServers server) {
            this.server = server.server();
            this.serverUrl = SERVERS.get((Object)server);
            return this;
        }

        public Builder retryConfig(RetryConfig retryConfig) {
            this.sdkConfiguration.setRetryConfig(Optional.of(retryConfig));
            return this;
        }

        Builder _hooks(Hooks hooks) {
            this.sdkConfiguration.setHooks(hooks);
            return this;
        }

        Builder _hooks(Consumer<? super Hooks> consumer) {
            consumer.accept(this.sdkConfiguration.hooks());
            return this;
        }

        public IamClient build() {
            if (this.serverUrl == null || this.serverUrl.isBlank()) {
                this.serverUrl = SERVERS.get((Object)AvailableServers.DEMO);
                this.server = AvailableServers.DEMO.server();
            }
            this.sdkConfiguration.setServerUrl(this.serverUrl);
            if (this.server != null) {
                this.sdkConfiguration.setServer(this.server);
            }
            return new IamClient(this.sdkConfiguration);
        }
    }

    public static enum AvailableServers {
        DEMO("demo"),
        PROD("prod");

        private final String server;

        private AvailableServers(String server) {
            this.server = server;
        }

        public String server() {
            return this.server;
        }
    }
}

