/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.rooms.api;

import com.docusign.rooms.client.ApiClient;
import com.docusign.rooms.client.ApiException;
import com.docusign.rooms.client.ApiResponse;
import com.docusign.rooms.client.Configuration;
import com.docusign.rooms.client.Pair;
import com.docusign.rooms.model.Envelope;
import com.docusign.rooms.model.EnvelopeForCreate;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class RoomEnvelopesApi {
    private ApiClient apiClient;

    public RoomEnvelopesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoomEnvelopesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Envelope createRoomEnvelope(String accountId, Integer roomId, EnvelopeForCreate body) throws ApiException {
        ApiResponse<Envelope> localVarResponse = this.createRoomEnvelopeWithHttpInfo(accountId, roomId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<Envelope> createRoomEnvelopeWithHttpInfo(String accountId, Integer roomId, EnvelopeForCreate body) throws ApiException {
        EnvelopeForCreate localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createRoomEnvelope");
        }
        if (roomId == null) {
            throw new ApiException(400, "Missing the required parameter 'roomId' when calling createRoomEnvelope");
        }
        String localVarPath = "/v2/accounts/{accountId}/rooms/{roomId}/envelopes".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{roomId\\}", this.apiClient.escapeString(roomId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Envelope> localVarReturnType = new GenericType<Envelope>(){};
        Envelope localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Envelope>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }
}

