/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.rooms.api;

import com.docusign.rooms.client.ApiClient;
import com.docusign.rooms.client.ApiException;
import com.docusign.rooms.client.ApiResponse;
import com.docusign.rooms.client.Configuration;
import com.docusign.rooms.client.Pair;
import com.docusign.rooms.model.FormGroup;
import com.docusign.rooms.model.FormGroupForCreate;
import com.docusign.rooms.model.FormGroupForUpdate;
import com.docusign.rooms.model.FormGroupFormToAssign;
import com.docusign.rooms.model.FormGroupSummaryList;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;

public class FormGroupsApi {
    private ApiClient apiClient;

    public FormGroupsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FormGroupsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public FormGroupFormToAssign assignFormGroupForm(String accountId, UUID formGroupId, FormGroupFormToAssign body) throws ApiException {
        ApiResponse<FormGroupFormToAssign> localVarResponse = this.assignFormGroupFormWithHttpInfo(accountId, formGroupId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<FormGroupFormToAssign> assignFormGroupFormWithHttpInfo(String accountId, UUID formGroupId, FormGroupFormToAssign body) throws ApiException {
        FormGroupFormToAssign localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling assignFormGroupForm");
        }
        if (formGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'formGroupId' when calling assignFormGroupForm");
        }
        String localVarPath = "/v2/accounts/{accountId}/form_groups/{formGroupId}/assign_form".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{formGroupId\\}", this.apiClient.escapeString(formGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json", "application/xml", "text/xml", "application/_*+xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<FormGroupFormToAssign> localVarReturnType = new GenericType<FormGroupFormToAssign>(){};
        FormGroupFormToAssign localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<FormGroupFormToAssign>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public FormGroup createFormGroup(String accountId, FormGroupForCreate body) throws ApiException {
        ApiResponse<FormGroup> localVarResponse = this.createFormGroupWithHttpInfo(accountId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<FormGroup> createFormGroupWithHttpInfo(String accountId, FormGroupForCreate body) throws ApiException {
        FormGroupForCreate localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createFormGroup");
        }
        String localVarPath = "/v2/accounts/{accountId}/form_groups".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json", "application/xml", "text/xml", "application/_*+xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<FormGroup> localVarReturnType = new GenericType<FormGroup>(){};
        FormGroup localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<FormGroup>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void deleteFormGroup(String accountId, UUID formGroupId) throws ApiException {
        this.deleteFormGroupWithHttpInfo(accountId, formGroupId);
    }

    public ApiResponse<Object> deleteFormGroupWithHttpInfo(String accountId, UUID formGroupId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteFormGroup");
        }
        if (formGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'formGroupId' when calling deleteFormGroup");
        }
        String localVarPath = "/v2/accounts/{accountId}/form_groups/{formGroupId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{formGroupId\\}", this.apiClient.escapeString(formGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public FormGroup getFormGroup(String accountId, UUID formGroupId) throws ApiException {
        ApiResponse<FormGroup> localVarResponse = this.getFormGroupWithHttpInfo(accountId, formGroupId);
        return localVarResponse.getData();
    }

    public ApiResponse<FormGroup> getFormGroupWithHttpInfo(String accountId, UUID formGroupId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getFormGroup");
        }
        if (formGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'formGroupId' when calling getFormGroup");
        }
        String localVarPath = "/v2/accounts/{accountId}/form_groups/{formGroupId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{formGroupId\\}", this.apiClient.escapeString(formGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<FormGroup> localVarReturnType = new GenericType<FormGroup>(){};
        FormGroup localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<FormGroup>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public FormGroupSummaryList getFormGroups(String accountId) throws ApiException {
        return this.getFormGroups(accountId, null);
    }

    public FormGroupSummaryList getFormGroups(String accountId, GetFormGroupsOptions options) throws ApiException {
        ApiResponse<FormGroupSummaryList> localVarResponse = this.getFormGroupsWithHttpInfo(accountId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<FormGroupSummaryList> getFormGroupsWithHttpInfo(String accountId, GetFormGroupsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getFormGroups");
        }
        String localVarPath = "/v2/accounts/{accountId}/form_groups".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startPosition", options.startPosition));
        }
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<FormGroupSummaryList> localVarReturnType = new GenericType<FormGroupSummaryList>(){};
        FormGroupSummaryList localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<FormGroupSummaryList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void grantOfficeAccessToFormGroup(String accountId, UUID formGroupId, Integer officeId) throws ApiException {
        this.grantOfficeAccessToFormGroupWithHttpInfo(accountId, formGroupId, officeId);
    }

    public ApiResponse<Object> grantOfficeAccessToFormGroupWithHttpInfo(String accountId, UUID formGroupId, Integer officeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling grantOfficeAccessToFormGroup");
        }
        if (formGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'formGroupId' when calling grantOfficeAccessToFormGroup");
        }
        if (officeId == null) {
            throw new ApiException(400, "Missing the required parameter 'officeId' when calling grantOfficeAccessToFormGroup");
        }
        String localVarPath = "/v2/accounts/{accountId}/form_groups/{formGroupId}/grant_office_access/{officeId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{formGroupId\\}", this.apiClient.escapeString(formGroupId.toString())).replaceAll("\\{officeId\\}", this.apiClient.escapeString(officeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void removeFormGroupForm(String accountId, UUID formGroupId, UUID formId) throws ApiException {
        this.removeFormGroupFormWithHttpInfo(accountId, formGroupId, formId);
    }

    public ApiResponse<Object> removeFormGroupFormWithHttpInfo(String accountId, UUID formGroupId, UUID formId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling removeFormGroupForm");
        }
        if (formGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'formGroupId' when calling removeFormGroupForm");
        }
        if (formId == null) {
            throw new ApiException(400, "Missing the required parameter 'formId' when calling removeFormGroupForm");
        }
        String localVarPath = "/v2/accounts/{accountId}/form_groups/{formGroupId}/unassign_form/{formId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{formGroupId\\}", this.apiClient.escapeString(formGroupId.toString())).replaceAll("\\{formId\\}", this.apiClient.escapeString(formId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public FormGroup renameFormGroup(String accountId, UUID formGroupId, FormGroupForUpdate body) throws ApiException {
        ApiResponse<FormGroup> localVarResponse = this.renameFormGroupWithHttpInfo(accountId, formGroupId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<FormGroup> renameFormGroupWithHttpInfo(String accountId, UUID formGroupId, FormGroupForUpdate body) throws ApiException {
        FormGroupForUpdate localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling renameFormGroup");
        }
        if (formGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'formGroupId' when calling renameFormGroup");
        }
        String localVarPath = "/v2/accounts/{accountId}/form_groups/{formGroupId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{formGroupId\\}", this.apiClient.escapeString(formGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json", "application/xml", "text/xml", "application/_*+xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<FormGroup> localVarReturnType = new GenericType<FormGroup>(){};
        FormGroup localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<FormGroup>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void revokeOfficeAccessFromFormGroup(String accountId, UUID formGroupId, Integer officeId) throws ApiException {
        this.revokeOfficeAccessFromFormGroupWithHttpInfo(accountId, formGroupId, officeId);
    }

    public ApiResponse<Object> revokeOfficeAccessFromFormGroupWithHttpInfo(String accountId, UUID formGroupId, Integer officeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling revokeOfficeAccessFromFormGroup");
        }
        if (formGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'formGroupId' when calling revokeOfficeAccessFromFormGroup");
        }
        if (officeId == null) {
            throw new ApiException(400, "Missing the required parameter 'officeId' when calling revokeOfficeAccessFromFormGroup");
        }
        String localVarPath = "/v2/accounts/{accountId}/form_groups/{formGroupId}/revoke_office_access/{officeId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{formGroupId\\}", this.apiClient.escapeString(formGroupId.toString())).replaceAll("\\{officeId\\}", this.apiClient.escapeString(officeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public class GetFormGroupsOptions {
        private Integer count = null;
        private Integer startPosition = null;

        public void setCount(Integer count) {
            this.count = count;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setStartPosition(Integer startPosition) {
            this.startPosition = startPosition;
        }

        public Integer getStartPosition() {
            return this.startPosition;
        }
    }
}

