/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.rooms.api;

import com.docusign.rooms.client.ApiClient;
import com.docusign.rooms.client.ApiException;
import com.docusign.rooms.client.ApiResponse;
import com.docusign.rooms.client.Configuration;
import com.docusign.rooms.client.Pair;
import com.docusign.rooms.model.ExternalFormFillSession;
import com.docusign.rooms.model.ExternalFormFillSessionForCreate;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class ExternalFormFillSessionsApi {
    private ApiClient apiClient;

    public ExternalFormFillSessionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExternalFormFillSessionsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ExternalFormFillSession createExternalFormFillSession(String accountId, ExternalFormFillSessionForCreate body) throws ApiException {
        ApiResponse<ExternalFormFillSession> localVarResponse = this.createExternalFormFillSessionWithHttpInfo(accountId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<ExternalFormFillSession> createExternalFormFillSessionWithHttpInfo(String accountId, ExternalFormFillSessionForCreate body) throws ApiException {
        ExternalFormFillSessionForCreate localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createExternalFormFillSession");
        }
        String localVarPath = "/v2/accounts/{accountId}/external_form_fill_sessions".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json", "application/xml", "text/xml", "application/_*+xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ExternalFormFillSession> localVarReturnType = new GenericType<ExternalFormFillSession>(){};
        ExternalFormFillSession localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ExternalFormFillSession>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }
}

