/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.util.Arrays;
import org.junit.jupiter.api.condition.BooleanExecutionCondition;
import org.junit.jupiter.api.condition.EnabledOnJre;
import org.junit.jupiter.api.condition.JRE;
import org.junit.platform.commons.util.Preconditions;

class EnabledOnJreCondition
extends BooleanExecutionCondition<EnabledOnJre> {
    static final String ENABLED_ON_CURRENT_JRE = "Enabled on JRE version: " + System.getProperty("java.version");
    static final String DISABLED_ON_CURRENT_JRE = "Disabled on JRE version: " + System.getProperty("java.version");

    EnabledOnJreCondition() {
        super(EnabledOnJre.class, ENABLED_ON_CURRENT_JRE, DISABLED_ON_CURRENT_JRE, EnabledOnJre::disabledReason);
    }

    @Override
    boolean isEnabled(EnabledOnJre annotation) {
        JRE[] versions = annotation.value();
        Preconditions.condition(versions.length > 0, "You must declare at least one JRE in @EnabledOnJre");
        return Arrays.stream(versions).anyMatch(JRE::isCurrentVersion);
    }
}

