/*
 * Decompiled with CFR 0.152.
 */
package org.json.zip;

import java.util.HashMap;
import org.json.Kim;
import org.json.zip.JSONzip;
import org.json.zip.Keep;
import org.json.zip.PostMortem;

class MapKeep
extends Keep {
    private Object[] list;
    private HashMap map;

    public MapKeep(int bits) {
        super(bits);
        this.list = new Object[this.capacity];
        this.map = new HashMap(this.capacity);
    }

    private void compact() {
        int to = 0;
        for (int from = 0; from < this.capacity; ++from) {
            Object key = this.list[from];
            long usage = MapKeep.age(this.uses[from]);
            if (usage > 0L) {
                this.uses[to] = usage;
                this.list[to] = key;
                this.map.put(key, new Integer(to));
                ++to;
                continue;
            }
            this.map.remove(key);
        }
        if (to < this.capacity) {
            this.length = to;
        } else {
            this.map.clear();
            this.length = 0;
        }
        this.power = 0;
    }

    public int find(Object key) {
        Object o = this.map.get(key);
        return o instanceof Integer ? (Integer)o : -1;
    }

    public boolean postMortem(PostMortem pm) {
        MapKeep that = (MapKeep)pm;
        if (this.length != that.length) {
            JSONzip.log(this.length + " <> " + that.length);
            return false;
        }
        for (int i2 = 0; i2 < this.length; ++i2) {
            boolean b;
            if (this.list[i2] instanceof Kim) {
                b = ((Kim)this.list[i2]).equals(that.list[i2]);
            } else {
                Object o = this.list[i2];
                Object q = that.list[i2];
                if (o instanceof Number) {
                    o = o.toString();
                }
                if (q instanceof Number) {
                    q = q.toString();
                }
                b = o.equals(q);
            }
            if (b) continue;
            JSONzip.log("\n[" + i2 + "]\n " + this.list[i2] + "\n " + that.list[i2] + "\n " + this.uses[i2] + "\n " + that.uses[i2]);
            return false;
        }
        return true;
    }

    public void register(Object value) {
        if (this.length >= this.capacity) {
            this.compact();
        }
        this.list[this.length] = value;
        this.map.put(value, new Integer(this.length));
        this.uses[this.length] = 1L;
        ++this.length;
    }

    public Object value(int integer) {
        return this.list[integer];
    }
}

