/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.rooms.api;

import com.docusign.rooms.client.ApiClient;
import com.docusign.rooms.client.ApiException;
import com.docusign.rooms.client.ApiResponse;
import com.docusign.rooms.client.Configuration;
import com.docusign.rooms.client.Pair;
import com.docusign.rooms.model.DesignatedOffice;
import com.docusign.rooms.model.DesignatedRegion;
import com.docusign.rooms.model.LockedOutDetails;
import com.docusign.rooms.model.User;
import com.docusign.rooms.model.UserForUpdate;
import com.docusign.rooms.model.UserSummaryList;
import com.docusign.rooms.model.UserToInvite;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class UsersApi {
    private ApiClient apiClient;

    public UsersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UsersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void addUserToOffice(String accountId, Integer userId, DesignatedOffice body) throws ApiException {
        this.addUserToOfficeWithHttpInfo(accountId, userId, body);
    }

    public ApiResponse<Object> addUserToOfficeWithHttpInfo(String accountId, Integer userId, DesignatedOffice body) throws ApiException {
        DesignatedOffice localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling addUserToOffice");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling addUserToOffice");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/add_to_office".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json", "application/xml", "text/xml", "application/_*+xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void addUserToRegion(String accountId, Integer userId, DesignatedRegion body) throws ApiException {
        this.addUserToRegionWithHttpInfo(accountId, userId, body);
    }

    public ApiResponse<Object> addUserToRegionWithHttpInfo(String accountId, Integer userId, DesignatedRegion body) throws ApiException {
        DesignatedRegion localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling addUserToRegion");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling addUserToRegion");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/add_to_region".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json", "application/xml", "text/xml", "application/_*+xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public User getUser(String accountId, Integer userId) throws ApiException {
        ApiResponse<User> localVarResponse = this.getUserWithHttpInfo(accountId, userId);
        return localVarResponse.getData();
    }

    public ApiResponse<User> getUserWithHttpInfo(String accountId, Integer userId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getUser");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getUser");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<User> localVarReturnType = new GenericType<User>(){};
        User localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<User>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public UserSummaryList getUsers(String accountId) throws ApiException {
        return this.getUsers(accountId, null);
    }

    public UserSummaryList getUsers(String accountId, GetUsersOptions options) throws ApiException {
        ApiResponse<UserSummaryList> localVarResponse = this.getUsersWithHttpInfo(accountId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<UserSummaryList> getUsersWithHttpInfo(String accountId, GetUsersOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getUsers");
        }
        String localVarPath = "/v2/accounts/{accountId}/users".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", options.filter));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", options.sort));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("defaultOfficeId", options.defaultOfficeId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("accessLevel", options.accessLevel));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("titleId", options.titleId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("roleId", options.roleId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", options.status));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("lockedOnly", options.lockedOnly));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startPosition", options.startPosition));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserSummaryList> localVarReturnType = new GenericType<UserSummaryList>(){};
        UserSummaryList localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UserSummaryList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public User inviteUser(String accountId, UserToInvite body) throws ApiException {
        ApiResponse<User> localVarResponse = this.inviteUserWithHttpInfo(accountId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<User> inviteUserWithHttpInfo(String accountId, UserToInvite body) throws ApiException {
        UserToInvite localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling inviteUser");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/invite_user".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<User> localVarReturnType = new GenericType<User>(){};
        User localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<User>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void lockUser(String accountId, Integer userId, LockedOutDetails body) throws ApiException {
        this.lockUserWithHttpInfo(accountId, userId, body);
    }

    public ApiResponse<Object> lockUserWithHttpInfo(String accountId, Integer userId, LockedOutDetails body) throws ApiException {
        LockedOutDetails localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling lockUser");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling lockUser");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/lock".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void reinviteUser(String accountId, Integer userId) throws ApiException {
        this.reinviteUserWithHttpInfo(accountId, userId);
    }

    public ApiResponse<Object> reinviteUserWithHttpInfo(String accountId, Integer userId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling reinviteUser");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling reinviteUser");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/reinvite".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void removeUser(String accountId, Integer userId) throws ApiException {
        this.removeUserWithHttpInfo(accountId, userId);
    }

    public ApiResponse<Object> removeUserWithHttpInfo(String accountId, Integer userId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling removeUser");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling removeUser");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void removeUserFromOffice(String accountId, Integer userId, DesignatedOffice body) throws ApiException {
        this.removeUserFromOfficeWithHttpInfo(accountId, userId, body);
    }

    public ApiResponse<Object> removeUserFromOfficeWithHttpInfo(String accountId, Integer userId, DesignatedOffice body) throws ApiException {
        DesignatedOffice localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling removeUserFromOffice");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling removeUserFromOffice");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/remove_from_office".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json", "application/xml", "text/xml", "application/_*+xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void removeUserFromRegion(String accountId, Integer userId, DesignatedRegion body) throws ApiException {
        this.removeUserFromRegionWithHttpInfo(accountId, userId, body);
    }

    public ApiResponse<Object> removeUserFromRegionWithHttpInfo(String accountId, Integer userId, DesignatedRegion body) throws ApiException {
        DesignatedRegion localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling removeUserFromRegion");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling removeUserFromRegion");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/remove_from_region".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json", "application/xml", "text/xml", "application/_*+xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void unlockUser(String accountId, Integer userId) throws ApiException {
        this.unlockUserWithHttpInfo(accountId, userId);
    }

    public ApiResponse<Object> unlockUserWithHttpInfo(String accountId, Integer userId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling unlockUser");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling unlockUser");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/unlock".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public User updateUser(String accountId, Integer userId, UserForUpdate body) throws ApiException {
        ApiResponse<User> localVarResponse = this.updateUserWithHttpInfo(accountId, userId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<User> updateUserWithHttpInfo(String accountId, Integer userId, UserForUpdate body) throws ApiException {
        UserForUpdate localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateUser");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateUser");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json", "application/xml", "text/xml", "application/_*+xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<User> localVarReturnType = new GenericType<User>(){};
        User localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<User>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public class GetUsersOptions {
        private String filter = null;
        private String sort = null;
        private Integer defaultOfficeId = null;
        private String accessLevel = null;
        private Integer titleId = null;
        private Integer roleId = null;
        private Object status = null;
        private Boolean lockedOnly = null;
        private Integer startPosition = null;
        private Integer count = null;

        public void setFilter(String filter) {
            this.filter = filter;
        }

        public String getFilter() {
            return this.filter;
        }

        public void setSort(String sort) {
            this.sort = sort;
        }

        public String getSort() {
            return this.sort;
        }

        public void setDefaultOfficeId(Integer defaultOfficeId) {
            this.defaultOfficeId = defaultOfficeId;
        }

        public Integer getDefaultOfficeId() {
            return this.defaultOfficeId;
        }

        public void setAccessLevel(String accessLevel) {
            this.accessLevel = accessLevel;
        }

        public String getAccessLevel() {
            return this.accessLevel;
        }

        public void setTitleId(Integer titleId) {
            this.titleId = titleId;
        }

        public Integer getTitleId() {
            return this.titleId;
        }

        public void setRoleId(Integer roleId) {
            this.roleId = roleId;
        }

        public Integer getRoleId() {
            return this.roleId;
        }

        public void setStatus(Object status) {
            this.status = status;
        }

        public Object getStatus() {
            return this.status;
        }

        public void setLockedOnly(Boolean lockedOnly) {
            this.lockedOnly = lockedOnly;
        }

        public Boolean getLockedOnly() {
            return this.lockedOnly;
        }

        public void setStartPosition(Integer startPosition) {
            this.startPosition = startPosition;
        }

        public Integer getStartPosition() {
            return this.startPosition;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        public Integer getCount() {
            return this.count;
        }
    }
}

