/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.rooms.api;

import com.docusign.rooms.client.ApiClient;
import com.docusign.rooms.client.ApiException;
import com.docusign.rooms.client.ApiResponse;
import com.docusign.rooms.client.Configuration;
import com.docusign.rooms.client.Pair;
import com.docusign.rooms.model.FormGroupFormList;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;

public class FormGroupFormsApi {
    private ApiClient apiClient;

    public FormGroupFormsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FormGroupFormsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public FormGroupFormList getFormGroupForms(String accountId, UUID formGroupId) throws ApiException {
        return this.getFormGroupForms(accountId, formGroupId, null);
    }

    public FormGroupFormList getFormGroupForms(String accountId, UUID formGroupId, GetFormGroupFormsOptions options) throws ApiException {
        ApiResponse<FormGroupFormList> localVarResponse = this.getFormGroupFormsWithHttpInfo(accountId, formGroupId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<FormGroupFormList> getFormGroupFormsWithHttpInfo(String accountId, UUID formGroupId, GetFormGroupFormsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getFormGroupForms");
        }
        if (formGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'formGroupId' when calling getFormGroupForms");
        }
        String localVarPath = "/v2/accounts/{accountId}/form_groups/{formGroupId}/forms".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{formGroupId\\}", this.apiClient.escapeString(formGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startPosition", options.startPosition));
        }
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<FormGroupFormList> localVarReturnType = new GenericType<FormGroupFormList>(){};
        FormGroupFormList localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<FormGroupFormList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public class GetFormGroupFormsOptions {
        private Integer count = null;
        private Integer startPosition = null;

        public void setCount(Integer count) {
            this.count = count;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setStartPosition(Integer startPosition) {
            this.startPosition = startPosition;
        }

        public Integer getStartPosition() {
            return this.startPosition;
        }
    }
}

