/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.ApiResponse;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.BulkSendBatchActionRequest;
import com.docusign.esign.model.BulkSendBatchRequest;
import com.docusign.esign.model.BulkSendBatchStatus;
import com.docusign.esign.model.BulkSendBatchSummaries;
import com.docusign.esign.model.BulkSendRequest;
import com.docusign.esign.model.BulkSendResponse;
import com.docusign.esign.model.BulkSendTestResponse;
import com.docusign.esign.model.BulkSendingList;
import com.docusign.esign.model.BulkSendingListSummaries;
import com.docusign.esign.model.EnvelopesInformation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class BulkEnvelopesApi {
    private ApiClient apiClient;

    public BulkEnvelopesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BulkEnvelopesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public BulkSendingList createBulkSendList(String accountId, BulkSendingList bulkSendingList) throws ApiException {
        ApiResponse<BulkSendingList> localVarResponse = this.createBulkSendListWithHttpInfo(accountId, bulkSendingList);
        return localVarResponse.getData();
    }

    public ApiResponse<BulkSendingList> createBulkSendListWithHttpInfo(String accountId, BulkSendingList bulkSendingList) throws ApiException {
        BulkSendingList localVarPostBody = bulkSendingList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createBulkSendList");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_send_lists".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkSendingList> localVarReturnType = new GenericType<BulkSendingList>(){};
        BulkSendingList localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<BulkSendingList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public BulkSendResponse createBulkSendRequest(String accountId, String bulkSendListId, BulkSendRequest bulkSendRequest) throws ApiException {
        ApiResponse<BulkSendResponse> localVarResponse = this.createBulkSendRequestWithHttpInfo(accountId, bulkSendListId, bulkSendRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<BulkSendResponse> createBulkSendRequestWithHttpInfo(String accountId, String bulkSendListId, BulkSendRequest bulkSendRequest) throws ApiException {
        BulkSendRequest localVarPostBody = bulkSendRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createBulkSendRequest");
        }
        if (bulkSendListId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkSendListId' when calling createBulkSendRequest");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}/send".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{bulkSendListId\\}", this.apiClient.escapeString(bulkSendListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkSendResponse> localVarReturnType = new GenericType<BulkSendResponse>(){};
        BulkSendResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<BulkSendResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public BulkSendTestResponse createBulkSendTestRequest(String accountId, String bulkSendListId, BulkSendRequest bulkSendRequest) throws ApiException {
        ApiResponse<BulkSendTestResponse> localVarResponse = this.createBulkSendTestRequestWithHttpInfo(accountId, bulkSendListId, bulkSendRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<BulkSendTestResponse> createBulkSendTestRequestWithHttpInfo(String accountId, String bulkSendListId, BulkSendRequest bulkSendRequest) throws ApiException {
        BulkSendRequest localVarPostBody = bulkSendRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createBulkSendTestRequest");
        }
        if (bulkSendListId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkSendListId' when calling createBulkSendTestRequest");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}/test".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{bulkSendListId\\}", this.apiClient.escapeString(bulkSendListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkSendTestResponse> localVarReturnType = new GenericType<BulkSendTestResponse>(){};
        BulkSendTestResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<BulkSendTestResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public BulkSendingListSummaries deleteBulkSendList(String accountId, String bulkSendListId) throws ApiException {
        ApiResponse<BulkSendingListSummaries> localVarResponse = this.deleteBulkSendListWithHttpInfo(accountId, bulkSendListId);
        return localVarResponse.getData();
    }

    public ApiResponse<BulkSendingListSummaries> deleteBulkSendListWithHttpInfo(String accountId, String bulkSendListId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteBulkSendList");
        }
        if (bulkSendListId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkSendListId' when calling deleteBulkSendList");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{bulkSendListId\\}", this.apiClient.escapeString(bulkSendListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkSendingListSummaries> localVarReturnType = new GenericType<BulkSendingListSummaries>(){};
        BulkSendingListSummaries localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<BulkSendingListSummaries>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EnvelopesInformation getBulkSendBatchEnvelopes(String accountId, String bulkSendBatchId) throws ApiException {
        return this.getBulkSendBatchEnvelopes(accountId, bulkSendBatchId, null);
    }

    public EnvelopesInformation getBulkSendBatchEnvelopes(String accountId, String bulkSendBatchId, GetBulkSendBatchEnvelopesOptions options) throws ApiException {
        ApiResponse<EnvelopesInformation> localVarResponse = this.getBulkSendBatchEnvelopesWithHttpInfo(accountId, bulkSendBatchId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<EnvelopesInformation> getBulkSendBatchEnvelopesWithHttpInfo(String accountId, String bulkSendBatchId, GetBulkSendBatchEnvelopesOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getBulkSendBatchEnvelopes");
        }
        if (bulkSendBatchId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkSendBatchId' when calling getBulkSendBatchEnvelopes");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_send_batch/{bulkSendBatchId}/envelopes".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{bulkSendBatchId\\}", this.apiClient.escapeString(bulkSendBatchId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include", options.include));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("order", options.order));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("order_by", options.orderBy));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("search_text", options.searchText));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_position", options.startPosition));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", options.status));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopesInformation> localVarReturnType = new GenericType<EnvelopesInformation>(){};
        EnvelopesInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EnvelopesInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public BulkSendBatchStatus getBulkSendBatchStatus(String accountId, String bulkSendBatchId) throws ApiException {
        ApiResponse<BulkSendBatchStatus> localVarResponse = this.getBulkSendBatchStatusWithHttpInfo(accountId, bulkSendBatchId);
        return localVarResponse.getData();
    }

    public ApiResponse<BulkSendBatchStatus> getBulkSendBatchStatusWithHttpInfo(String accountId, String bulkSendBatchId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getBulkSendBatchStatus");
        }
        if (bulkSendBatchId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkSendBatchId' when calling getBulkSendBatchStatus");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_send_batch/{bulkSendBatchId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{bulkSendBatchId\\}", this.apiClient.escapeString(bulkSendBatchId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkSendBatchStatus> localVarReturnType = new GenericType<BulkSendBatchStatus>(){};
        BulkSendBatchStatus localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<BulkSendBatchStatus>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public BulkSendBatchSummaries getBulkSendBatches(String accountId) throws ApiException {
        return this.getBulkSendBatches(accountId, null);
    }

    public BulkSendBatchSummaries getBulkSendBatches(String accountId, GetBulkSendBatchesOptions options) throws ApiException {
        ApiResponse<BulkSendBatchSummaries> localVarResponse = this.getBulkSendBatchesWithHttpInfo(accountId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<BulkSendBatchSummaries> getBulkSendBatchesWithHttpInfo(String accountId, GetBulkSendBatchesOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getBulkSendBatches");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_send_batch".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("batch_ids", options.batchIds));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from_date", options.fromDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("search_text", options.searchText));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_position", options.startPosition));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", options.status));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to_date", options.toDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("user_id", options.userId));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkSendBatchSummaries> localVarReturnType = new GenericType<BulkSendBatchSummaries>(){};
        BulkSendBatchSummaries localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<BulkSendBatchSummaries>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public BulkSendingList getBulkSendList(String accountId, String bulkSendListId) throws ApiException {
        ApiResponse<BulkSendingList> localVarResponse = this.getBulkSendListWithHttpInfo(accountId, bulkSendListId);
        return localVarResponse.getData();
    }

    public ApiResponse<BulkSendingList> getBulkSendListWithHttpInfo(String accountId, String bulkSendListId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getBulkSendList");
        }
        if (bulkSendListId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkSendListId' when calling getBulkSendList");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{bulkSendListId\\}", this.apiClient.escapeString(bulkSendListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkSendingList> localVarReturnType = new GenericType<BulkSendingList>(){};
        BulkSendingList localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<BulkSendingList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public BulkSendingListSummaries getBulkSendLists(String accountId) throws ApiException {
        ApiResponse<BulkSendingListSummaries> localVarResponse = this.getBulkSendListsWithHttpInfo(accountId);
        return localVarResponse.getData();
    }

    public ApiResponse<BulkSendingListSummaries> getBulkSendListsWithHttpInfo(String accountId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getBulkSendLists");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_send_lists".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkSendingListSummaries> localVarReturnType = new GenericType<BulkSendingListSummaries>(){};
        BulkSendingListSummaries localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<BulkSendingListSummaries>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public BulkSendBatchStatus updateBulkSendBatchAction(String accountId, String bulkSendBatchId, String bulkAction, BulkSendBatchActionRequest bulkSendBatchActionRequest) throws ApiException {
        ApiResponse<BulkSendBatchStatus> localVarResponse = this.updateBulkSendBatchActionWithHttpInfo(accountId, bulkSendBatchId, bulkAction, bulkSendBatchActionRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<BulkSendBatchStatus> updateBulkSendBatchActionWithHttpInfo(String accountId, String bulkSendBatchId, String bulkAction, BulkSendBatchActionRequest bulkSendBatchActionRequest) throws ApiException {
        BulkSendBatchActionRequest localVarPostBody = bulkSendBatchActionRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateBulkSendBatchAction");
        }
        if (bulkSendBatchId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkSendBatchId' when calling updateBulkSendBatchAction");
        }
        if (bulkAction == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkAction' when calling updateBulkSendBatchAction");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_send_batch/{bulkSendBatchId}/{bulkAction}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{bulkSendBatchId\\}", this.apiClient.escapeString(bulkSendBatchId.toString())).replaceAll("\\{bulkAction\\}", this.apiClient.escapeString(bulkAction.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkSendBatchStatus> localVarReturnType = new GenericType<BulkSendBatchStatus>(){};
        BulkSendBatchStatus localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<BulkSendBatchStatus>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public BulkSendBatchStatus updateBulkSendBatchStatus(String accountId, String bulkSendBatchId, BulkSendBatchRequest bulkSendBatchRequest) throws ApiException {
        ApiResponse<BulkSendBatchStatus> localVarResponse = this.updateBulkSendBatchStatusWithHttpInfo(accountId, bulkSendBatchId, bulkSendBatchRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<BulkSendBatchStatus> updateBulkSendBatchStatusWithHttpInfo(String accountId, String bulkSendBatchId, BulkSendBatchRequest bulkSendBatchRequest) throws ApiException {
        BulkSendBatchRequest localVarPostBody = bulkSendBatchRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateBulkSendBatchStatus");
        }
        if (bulkSendBatchId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkSendBatchId' when calling updateBulkSendBatchStatus");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_send_batch/{bulkSendBatchId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{bulkSendBatchId\\}", this.apiClient.escapeString(bulkSendBatchId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkSendBatchStatus> localVarReturnType = new GenericType<BulkSendBatchStatus>(){};
        BulkSendBatchStatus localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<BulkSendBatchStatus>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public BulkSendingList updateBulkSendList(String accountId, String bulkSendListId, BulkSendingList bulkSendingList) throws ApiException {
        ApiResponse<BulkSendingList> localVarResponse = this.updateBulkSendListWithHttpInfo(accountId, bulkSendListId, bulkSendingList);
        return localVarResponse.getData();
    }

    public ApiResponse<BulkSendingList> updateBulkSendListWithHttpInfo(String accountId, String bulkSendListId, BulkSendingList bulkSendingList) throws ApiException {
        BulkSendingList localVarPostBody = bulkSendingList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateBulkSendList");
        }
        if (bulkSendListId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkSendListId' when calling updateBulkSendList");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{bulkSendListId\\}", this.apiClient.escapeString(bulkSendListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkSendingList> localVarReturnType = new GenericType<BulkSendingList>(){};
        BulkSendingList localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<BulkSendingList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public class GetBulkSendBatchesOptions {
        private String batchIds = null;
        private String count = null;
        private String fromDate = null;
        private String searchText = null;
        private String startPosition = null;
        private String status = null;
        private String toDate = null;
        private String userId = null;

        public void setBatchIds(String batchIds) {
            this.batchIds = batchIds;
        }

        public String getBatchIds() {
            return this.batchIds;
        }

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        public String getSearchText() {
            return this.searchText;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getUserId() {
            return this.userId;
        }
    }

    public class GetBulkSendBatchEnvelopesOptions {
        private String count = null;
        private String include = null;
        private String order = null;
        private String orderBy = null;
        private String searchText = null;
        private String startPosition = null;
        private String status = null;

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }

        public void setOrder(String order) {
            this.order = order;
        }

        public String getOrder() {
            return this.order;
        }

        public void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        public String getOrderBy() {
            return this.orderBy;
        }

        public void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        public String getSearchText() {
            return this.searchText;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }
    }
}

