/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.click.model;

import com.docusign.click.model.DataField;
import com.docusign.click.model.DisplaySettings;
import com.docusign.click.model.Document;
import com.docusign.click.model.UserAgreementResponseStyle;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UserAgreementResponse {
    @JsonProperty(value="accountId")
    private String accountId = null;
    @JsonProperty(value="agreedOn")
    private Object agreedOn = null;
    @JsonProperty(value="agreementId")
    private String agreementId = null;
    @JsonProperty(value="agreementUrl")
    private String agreementUrl = null;
    @JsonProperty(value="clickwrapId")
    private String clickwrapId = null;
    @JsonProperty(value="clientUserId")
    private String clientUserId = null;
    @JsonProperty(value="consumerDisclosureEnabled")
    private Boolean consumerDisclosureEnabled = null;
    @JsonProperty(value="consumerDisclosureHtml")
    private String consumerDisclosureHtml = null;
    @JsonProperty(value="createdOn")
    private Object createdOn = null;
    @JsonProperty(value="dataFields")
    private List<DataField> dataFields = null;
    @JsonProperty(value="declinedOn")
    private Object declinedOn = null;
    @JsonProperty(value="documentData")
    private Map<String, String> documentData = null;
    @JsonProperty(value="documents")
    private List<Document> documents = null;
    @JsonProperty(value="metadata")
    private String metadata = null;
    @JsonProperty(value="returnUrl")
    private String returnUrl = null;
    @JsonProperty(value="settings")
    private DisplaySettings settings = null;
    @JsonProperty(value="status")
    private String status = null;
    @JsonProperty(value="style")
    private UserAgreementResponseStyle style = null;
    @JsonProperty(value="version")
    private String version = null;
    @JsonProperty(value="versionId")
    private String versionId = null;
    @JsonProperty(value="versionNumber")
    private Integer versionNumber = null;

    public UserAgreementResponse accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Schema(description="The external account number (int) or account ID GUID.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public UserAgreementResponse agreedOn(Object agreedOn) {
        this.agreedOn = agreedOn;
        return this;
    }

    @Schema(description="Date that the client last completed the agreement.  This property is null if `agreementUrl` is not null and `status` is not  `agreed`.")
    public Object getAgreedOn() {
        return this.agreedOn;
    }

    public void setAgreedOn(Object agreedOn) {
        this.agreedOn = agreedOn;
    }

    public UserAgreementResponse agreementId(String agreementId) {
        this.agreementId = agreementId;
        return this;
    }

    @Schema(description="The agreement ID.")
    public String getAgreementId() {
        return this.agreementId;
    }

    public void setAgreementId(String agreementId) {
        this.agreementId = agreementId;
    }

    public UserAgreementResponse agreementUrl(String agreementUrl) {
        this.agreementUrl = agreementUrl;
        return this;
    }

    @Schema(description="When not null, an agreement is required for user specified by  `clientUserId`.  When missing the user specified by `clientUserId` has already agreed and does not require a new acceptance.  Use this URL to render the agreement in a web page.  <!-- or redirected to when providing redirect_url as a query parameter. --> ")
    public String getAgreementUrl() {
        return this.agreementUrl;
    }

    public void setAgreementUrl(String agreementUrl) {
        this.agreementUrl = agreementUrl;
    }

    public UserAgreementResponse clickwrapId(String clickwrapId) {
        this.clickwrapId = clickwrapId;
        return this;
    }

    @Schema(description="The ID of the clickwrap.")
    public String getClickwrapId() {
        return this.clickwrapId;
    }

    public void setClickwrapId(String clickwrapId) {
        this.clickwrapId = clickwrapId;
    }

    public UserAgreementResponse clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @Schema(description="A unique value that identifies a user.\\nYou can use anything that your system uses\\nto identify unique users, such as\\nemployee IDs, email addresses, and surrogate keys as the value of `clientUserId`.\\n\\nA clickwrap with a specific `clientUserId` will not appear again\\nonce it has been accepted.\\n\"")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public UserAgreementResponse consumerDisclosureEnabled(Boolean consumerDisclosureEnabled) {
        this.consumerDisclosureEnabled = consumerDisclosureEnabled;
        return this;
    }

    @Schema(description="**True** if consumer disclosure was required by this agreement.")
    public Boolean isConsumerDisclosureEnabled() {
        return this.consumerDisclosureEnabled;
    }

    public void setConsumerDisclosureEnabled(Boolean consumerDisclosureEnabled) {
        this.consumerDisclosureEnabled = consumerDisclosureEnabled;
    }

    public UserAgreementResponse consumerDisclosureHtml(String consumerDisclosureHtml) {
        this.consumerDisclosureHtml = consumerDisclosureHtml;
        return this;
    }

    @Schema(description="The customer-branded HTML with the Electronic Record and Signature Disclosure information")
    public String getConsumerDisclosureHtml() {
        return this.consumerDisclosureHtml;
    }

    public void setConsumerDisclosureHtml(String consumerDisclosureHtml) {
        this.consumerDisclosureHtml = consumerDisclosureHtml;
    }

    public UserAgreementResponse createdOn(Object createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    @Schema(description="The date when the clickwrap was created. May be null.")
    public Object getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Object createdOn) {
        this.createdOn = createdOn;
    }

    public UserAgreementResponse dataFields(List<DataField> dataFields) {
        this.dataFields = dataFields;
        return this;
    }

    public UserAgreementResponse addDataFieldsItem(DataField dataFieldsItem) {
        if (this.dataFields == null) {
            this.dataFields = new ArrayList<DataField>();
        }
        this.dataFields.add(dataFieldsItem);
        return this;
    }

    @Schema(description="The list of all the data fields available for the clickwrap (custom fields and standard fields).")
    public List<DataField> getDataFields() {
        return this.dataFields;
    }

    public void setDataFields(List<DataField> dataFields) {
        this.dataFields = dataFields;
    }

    public UserAgreementResponse declinedOn(Object declinedOn) {
        this.declinedOn = declinedOn;
        return this;
    }

    @Schema(description="The date when the user declined the most recent required agreement.  This property is valid only when `status` is `declined`. Otherwise it is null.")
    public Object getDeclinedOn() {
        return this.declinedOn;
    }

    public void setDeclinedOn(Object declinedOn) {
        this.declinedOn = declinedOn;
    }

    public UserAgreementResponse documentData(Map<String, String> documentData) {
        this.documentData = documentData;
        return this;
    }

    public UserAgreementResponse putDocumentDataItem(String key, String documentDataItem) {
        if (this.documentData == null) {
            this.documentData = new HashMap<String, String>();
        }
        this.documentData.put(key, documentDataItem);
        return this;
    }

    @Schema(description="This property specifies the data used to create a clickwrap with [dynamic content][].    [dynamic content]: /docs/click-api/click101/customize-clickwrap-fields/#embed-clickwraps-that-contain-dynamic-content ")
    public Map<String, String> getDocumentData() {
        return this.documentData;
    }

    public void setDocumentData(Map<String, String> documentData) {
        this.documentData = documentData;
    }

    public UserAgreementResponse documents(List<Document> documents) {
        this.documents = documents;
        return this;
    }

    public UserAgreementResponse addDocumentsItem(Document documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<Document>();
        }
        this.documents.add(documentsItem);
        return this;
    }

    @Schema(description="An array of documents.")
    public List<Document> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    public UserAgreementResponse metadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    @Schema(description="A customer-defined string you can use in requests. This string will appear in the corresponding response.")
    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public UserAgreementResponse returnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
        return this;
    }

    @Schema(description="The URL redirected to after the agreement was completed.")
    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public UserAgreementResponse settings(DisplaySettings settings) {
        this.settings = settings;
        return this;
    }

    @Schema(description="The display settings for this agreement.")
    public DisplaySettings getSettings() {
        return this.settings;
    }

    public void setSettings(DisplaySettings settings) {
        this.settings = settings;
    }

    public UserAgreementResponse status(String status) {
        this.status = status;
        return this;
    }

    @Schema(description="User agreement status. One of:  - `created` - `agreed` - `declined`")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public UserAgreementResponse style(UserAgreementResponseStyle style) {
        this.style = style;
        return this;
    }

    @Schema(description="")
    public UserAgreementResponseStyle getStyle() {
        return this.style;
    }

    public void setStyle(UserAgreementResponseStyle style) {
        this.style = style;
    }

    public UserAgreementResponse version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="The human-readable semver version string.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public UserAgreementResponse versionId(String versionId) {
        this.versionId = versionId;
        return this;
    }

    @Schema(description="The ID of the version.")
    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public UserAgreementResponse versionNumber(Integer versionNumber) {
        this.versionNumber = versionNumber;
        return this;
    }

    @Schema(description="Version of the clickwrap.")
    public Integer getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(Integer versionNumber) {
        this.versionNumber = versionNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAgreementResponse userAgreementResponse = (UserAgreementResponse)o;
        return Objects.equals(this.accountId, userAgreementResponse.accountId) && Objects.equals(this.agreedOn, userAgreementResponse.agreedOn) && Objects.equals(this.agreementId, userAgreementResponse.agreementId) && Objects.equals(this.agreementUrl, userAgreementResponse.agreementUrl) && Objects.equals(this.clickwrapId, userAgreementResponse.clickwrapId) && Objects.equals(this.clientUserId, userAgreementResponse.clientUserId) && Objects.equals(this.consumerDisclosureEnabled, userAgreementResponse.consumerDisclosureEnabled) && Objects.equals(this.consumerDisclosureHtml, userAgreementResponse.consumerDisclosureHtml) && Objects.equals(this.createdOn, userAgreementResponse.createdOn) && Objects.equals(this.dataFields, userAgreementResponse.dataFields) && Objects.equals(this.declinedOn, userAgreementResponse.declinedOn) && Objects.equals(this.documentData, userAgreementResponse.documentData) && Objects.equals(this.documents, userAgreementResponse.documents) && Objects.equals(this.metadata, userAgreementResponse.metadata) && Objects.equals(this.returnUrl, userAgreementResponse.returnUrl) && Objects.equals(this.settings, userAgreementResponse.settings) && Objects.equals(this.status, userAgreementResponse.status) && Objects.equals(this.style, userAgreementResponse.style) && Objects.equals(this.version, userAgreementResponse.version) && Objects.equals(this.versionId, userAgreementResponse.versionId) && Objects.equals(this.versionNumber, userAgreementResponse.versionNumber);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.agreedOn, this.agreementId, this.agreementUrl, this.clickwrapId, this.clientUserId, this.consumerDisclosureEnabled, this.consumerDisclosureHtml, this.createdOn, this.dataFields, this.declinedOn, this.documentData, this.documents, this.metadata, this.returnUrl, this.settings, this.status, this.style, this.version, this.versionId, this.versionNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserAgreementResponse {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    agreedOn: ").append(this.toIndentedString(this.agreedOn)).append("\n");
        sb.append("    agreementId: ").append(this.toIndentedString(this.agreementId)).append("\n");
        sb.append("    agreementUrl: ").append(this.toIndentedString(this.agreementUrl)).append("\n");
        sb.append("    clickwrapId: ").append(this.toIndentedString(this.clickwrapId)).append("\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    consumerDisclosureEnabled: ").append(this.toIndentedString(this.consumerDisclosureEnabled)).append("\n");
        sb.append("    consumerDisclosureHtml: ").append(this.toIndentedString(this.consumerDisclosureHtml)).append("\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    dataFields: ").append(this.toIndentedString(this.dataFields)).append("\n");
        sb.append("    declinedOn: ").append(this.toIndentedString(this.declinedOn)).append("\n");
        sb.append("    documentData: ").append(this.toIndentedString(this.documentData)).append("\n");
        sb.append("    documents: ").append(this.toIndentedString(this.documents)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    returnUrl: ").append(this.toIndentedString(this.returnUrl)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    versionId: ").append(this.toIndentedString(this.versionId)).append("\n");
        sb.append("    versionNumber: ").append(this.toIndentedString(this.versionNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

