/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.click.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Schema(description="Data used to create the agreement.")
public class UserAgreementRequest {
    @JsonProperty(value="clientUserId")
    private String clientUserId = null;
    @JsonProperty(value="documentData")
    private Map<String, String> documentData = null;
    @JsonProperty(value="metadata")
    private String metadata = null;
    @JsonProperty(value="returnUrl")
    private String returnUrl = null;

    public UserAgreementRequest clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @Schema(description="A unique value that identifies a user. You can use anything that your system uses to identify unique users, such as employee IDs, email addresses, and surrogate keys as the value of `clientUserId`.  A clickwrap with a specific `clientUserId` will not appear again once it has been accepted. ")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public UserAgreementRequest documentData(Map<String, String> documentData) {
        this.documentData = documentData;
        return this;
    }

    public UserAgreementRequest putDocumentDataItem(String key, String documentDataItem) {
        if (this.documentData == null) {
            this.documentData = new HashMap<String, String>();
        }
        this.documentData.put(key, documentDataItem);
        return this;
    }

    @Schema(description="This property specifies the data used to create a clickwrap with [dynamic content][].    [dynamic content]: /docs/click-api/click101/customize-clickwrap-fields/#embed-clickwraps-that-contain-dynamic-content ")
    public Map<String, String> getDocumentData() {
        return this.documentData;
    }

    public void setDocumentData(Map<String, String> documentData) {
        this.documentData = documentData;
    }

    public UserAgreementRequest metadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    @Schema(description="A customer-defined string you can use in requests. This string will appear in the corresponding response.")
    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public UserAgreementRequest returnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
        return this;
    }

    @Schema(description="The URL to redirect to after the agreement is complete when the agreement is not rendered in an iframe.")
    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAgreementRequest userAgreementRequest = (UserAgreementRequest)o;
        return Objects.equals(this.clientUserId, userAgreementRequest.clientUserId) && Objects.equals(this.documentData, userAgreementRequest.documentData) && Objects.equals(this.metadata, userAgreementRequest.metadata) && Objects.equals(this.returnUrl, userAgreementRequest.returnUrl);
    }

    public int hashCode() {
        return Objects.hash(this.clientUserId, this.documentData, this.metadata, this.returnUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserAgreementRequest {\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    documentData: ").append(this.toIndentedString(this.documentData)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    returnUrl: ").append(this.toIndentedString(this.returnUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

