/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.click.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="The result of a clickwrap deletion request.")
public class ClickwrapDeleteResponse {
    @JsonProperty(value="clickwrapId")
    private String clickwrapId = null;
    @JsonProperty(value="clickwrapName")
    private String clickwrapName = null;
    @JsonProperty(value="deletionMessage")
    private String deletionMessage = null;
    @JsonProperty(value="deletionSuccess")
    private Boolean deletionSuccess = null;
    @JsonProperty(value="status")
    private String status = null;

    public ClickwrapDeleteResponse clickwrapId(String clickwrapId) {
        this.clickwrapId = clickwrapId;
        return this;
    }

    @Schema(description="The ID of the clickwrap.")
    public String getClickwrapId() {
        return this.clickwrapId;
    }

    public void setClickwrapId(String clickwrapId) {
        this.clickwrapId = clickwrapId;
    }

    public ClickwrapDeleteResponse clickwrapName(String clickwrapName) {
        this.clickwrapName = clickwrapName;
        return this;
    }

    @Schema(description="The name of the clickwrap.")
    public String getClickwrapName() {
        return this.clickwrapName;
    }

    public void setClickwrapName(String clickwrapName) {
        this.clickwrapName = clickwrapName;
    }

    public ClickwrapDeleteResponse deletionMessage(String deletionMessage) {
        this.deletionMessage = deletionMessage;
        return this;
    }

    @Schema(description="A message describing the result of deletion request. One of:  - `alreadyDeleted`: Clickwrap is already deleted. - `deletionSuccess`: Successfully deleted the clickwrap. - `deletionFailure`: Failed to delete the clickwrap. - `cannotDelete`: Active clickwrap version cannot be deleted.")
    public String getDeletionMessage() {
        return this.deletionMessage;
    }

    public void setDeletionMessage(String deletionMessage) {
        this.deletionMessage = deletionMessage;
    }

    public ClickwrapDeleteResponse deletionSuccess(Boolean deletionSuccess) {
        this.deletionSuccess = deletionSuccess;
        return this;
    }

    @Schema(description="**True** if the clickwrap was deleted successfully. **False** otherwise.")
    public Boolean isDeletionSuccess() {
        return this.deletionSuccess;
    }

    public void setDeletionSuccess(Boolean deletionSuccess) {
        this.deletionSuccess = deletionSuccess;
    }

    public ClickwrapDeleteResponse status(String status) {
        this.status = status;
        return this;
    }

    @Schema(description="Clickwrap status. Possible values:  - `active` - `inactive` - `deleted`")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClickwrapDeleteResponse clickwrapDeleteResponse = (ClickwrapDeleteResponse)o;
        return Objects.equals(this.clickwrapId, clickwrapDeleteResponse.clickwrapId) && Objects.equals(this.clickwrapName, clickwrapDeleteResponse.clickwrapName) && Objects.equals(this.deletionMessage, clickwrapDeleteResponse.deletionMessage) && Objects.equals(this.deletionSuccess, clickwrapDeleteResponse.deletionSuccess) && Objects.equals(this.status, clickwrapDeleteResponse.status);
    }

    public int hashCode() {
        return Objects.hash(this.clickwrapId, this.clickwrapName, this.deletionMessage, this.deletionSuccess, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClickwrapDeleteResponse {\n");
        sb.append("    clickwrapId: ").append(this.toIndentedString(this.clickwrapId)).append("\n");
        sb.append("    clickwrapName: ").append(this.toIndentedString(this.clickwrapName)).append("\n");
        sb.append("    deletionMessage: ").append(this.toIndentedString(this.deletionMessage)).append("\n");
        sb.append("    deletionSuccess: ").append(this.toIndentedString(this.deletionSuccess)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

