/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.click.api;

import com.docusign.click.client.ApiClient;
import com.docusign.click.client.ApiException;
import com.docusign.click.client.ApiResponse;
import com.docusign.click.client.Configuration;
import com.docusign.click.client.Pair;
import com.docusign.click.model.BulkClickwrapRequest;
import com.docusign.click.model.ClickwrapAgreementsResponse;
import com.docusign.click.model.ClickwrapRequest;
import com.docusign.click.model.ClickwrapTransferRequest;
import com.docusign.click.model.ClickwrapVersionDeleteResponse;
import com.docusign.click.model.ClickwrapVersionResponse;
import com.docusign.click.model.ClickwrapVersionSummaryResponse;
import com.docusign.click.model.ClickwrapVersionsDeleteResponse;
import com.docusign.click.model.ClickwrapVersionsPagedResponse;
import com.docusign.click.model.ClickwrapVersionsResponse;
import com.docusign.click.model.ClickwrapsDeleteResponse;
import com.docusign.click.model.Document;
import com.docusign.click.model.ServiceInformation;
import com.docusign.click.model.UserAgreementRequest;
import com.docusign.click.model.UserAgreementResponse;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class AccountsApi {
    private ApiClient apiClient;

    public AccountsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AccountsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void createBulkClickwrapAgreements(String accountId, String clickwrapId, BulkClickwrapRequest bulkClickwrapRequest) throws ApiException {
        this.createBulkClickwrapAgreementsWithHttpInfo(accountId, clickwrapId, bulkClickwrapRequest);
    }

    public ApiResponse<Object> createBulkClickwrapAgreementsWithHttpInfo(String accountId, String clickwrapId, BulkClickwrapRequest bulkClickwrapRequest) throws ApiException {
        BulkClickwrapRequest localVarPostBody = bulkClickwrapRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createBulkClickwrapAgreements");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling createBulkClickwrapAgreements");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/bulk_agreements".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public ClickwrapVersionSummaryResponse createClickwrap(String accountId, ClickwrapRequest clickwrapRequest) throws ApiException {
        ApiResponse<ClickwrapVersionSummaryResponse> localVarResponse = this.createClickwrapWithHttpInfo(accountId, clickwrapRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<ClickwrapVersionSummaryResponse> createClickwrapWithHttpInfo(String accountId, ClickwrapRequest clickwrapRequest) throws ApiException {
        ClickwrapRequest localVarPostBody = clickwrapRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createClickwrap");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionSummaryResponse> localVarReturnType = new GenericType<ClickwrapVersionSummaryResponse>(){};
        ClickwrapVersionSummaryResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ClickwrapVersionSummaryResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ClickwrapVersionSummaryResponse createClickwrapVersion(String accountId, String clickwrapId, ClickwrapRequest clickwrapRequest) throws ApiException {
        ApiResponse<ClickwrapVersionSummaryResponse> localVarResponse = this.createClickwrapVersionWithHttpInfo(accountId, clickwrapId, clickwrapRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<ClickwrapVersionSummaryResponse> createClickwrapVersionWithHttpInfo(String accountId, String clickwrapId, ClickwrapRequest clickwrapRequest) throws ApiException {
        ClickwrapRequest localVarPostBody = clickwrapRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createClickwrapVersion");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling createClickwrapVersion");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionSummaryResponse> localVarReturnType = new GenericType<ClickwrapVersionSummaryResponse>(){};
        ClickwrapVersionSummaryResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ClickwrapVersionSummaryResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public UserAgreementResponse createHasAgreed(String accountId, String clickwrapId, UserAgreementRequest userAgreementRequest) throws ApiException {
        ApiResponse<UserAgreementResponse> localVarResponse = this.createHasAgreedWithHttpInfo(accountId, clickwrapId, userAgreementRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UserAgreementResponse> createHasAgreedWithHttpInfo(String accountId, String clickwrapId, UserAgreementRequest userAgreementRequest) throws ApiException {
        UserAgreementRequest localVarPostBody = userAgreementRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createHasAgreed");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling createHasAgreed");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/agreements".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserAgreementResponse> localVarReturnType = new GenericType<UserAgreementResponse>(){};
        UserAgreementResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UserAgreementResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ClickwrapVersionsDeleteResponse deleteClickwrap(String accountId, String clickwrapId) throws ApiException {
        return this.deleteClickwrap(accountId, clickwrapId, null);
    }

    public ClickwrapVersionsDeleteResponse deleteClickwrap(String accountId, String clickwrapId, DeleteClickwrapOptions options) throws ApiException {
        ApiResponse<ClickwrapVersionsDeleteResponse> localVarResponse = this.deleteClickwrapWithHttpInfo(accountId, clickwrapId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<ClickwrapVersionsDeleteResponse> deleteClickwrapWithHttpInfo(String accountId, String clickwrapId, DeleteClickwrapOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteClickwrap");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling deleteClickwrap");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("versions", options.versions));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionsDeleteResponse> localVarReturnType = new GenericType<ClickwrapVersionsDeleteResponse>(){};
        ClickwrapVersionsDeleteResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ClickwrapVersionsDeleteResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ClickwrapVersionDeleteResponse deleteClickwrapVersion(String accountId, String clickwrapId, String versionId) throws ApiException {
        ApiResponse<ClickwrapVersionDeleteResponse> localVarResponse = this.deleteClickwrapVersionWithHttpInfo(accountId, clickwrapId, versionId);
        return localVarResponse.getData();
    }

    public ApiResponse<ClickwrapVersionDeleteResponse> deleteClickwrapVersionWithHttpInfo(String accountId, String clickwrapId, String versionId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteClickwrapVersion");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling deleteClickwrapVersion");
        }
        if (versionId == null) {
            throw new ApiException(400, "Missing the required parameter 'versionId' when calling deleteClickwrapVersion");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions/{versionId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString())).replaceAll("\\{versionId\\}", this.apiClient.escapeString(versionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionDeleteResponse> localVarReturnType = new GenericType<ClickwrapVersionDeleteResponse>(){};
        ClickwrapVersionDeleteResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ClickwrapVersionDeleteResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ClickwrapVersionsDeleteResponse deleteClickwrapVersions(String accountId, String clickwrapId) throws ApiException {
        return this.deleteClickwrapVersions(accountId, clickwrapId, null);
    }

    public ClickwrapVersionsDeleteResponse deleteClickwrapVersions(String accountId, String clickwrapId, DeleteClickwrapVersionsOptions options) throws ApiException {
        ApiResponse<ClickwrapVersionsDeleteResponse> localVarResponse = this.deleteClickwrapVersionsWithHttpInfo(accountId, clickwrapId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<ClickwrapVersionsDeleteResponse> deleteClickwrapVersionsWithHttpInfo(String accountId, String clickwrapId, DeleteClickwrapVersionsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteClickwrapVersions");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling deleteClickwrapVersions");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("clickwrapVersionIds", options.clickwrapVersionIds));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionsDeleteResponse> localVarReturnType = new GenericType<ClickwrapVersionsDeleteResponse>(){};
        ClickwrapVersionsDeleteResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ClickwrapVersionsDeleteResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ClickwrapsDeleteResponse deleteClickwraps(String accountId) throws ApiException {
        return this.deleteClickwraps(accountId, null);
    }

    public ClickwrapsDeleteResponse deleteClickwraps(String accountId, DeleteClickwrapsOptions options) throws ApiException {
        ApiResponse<ClickwrapsDeleteResponse> localVarResponse = this.deleteClickwrapsWithHttpInfo(accountId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<ClickwrapsDeleteResponse> deleteClickwrapsWithHttpInfo(String accountId, DeleteClickwrapsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteClickwraps");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("clickwrapIds", options.clickwrapIds));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapsDeleteResponse> localVarReturnType = new GenericType<ClickwrapsDeleteResponse>(){};
        ClickwrapsDeleteResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ClickwrapsDeleteResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public UserAgreementResponse getAgreement(String accountId, String clickwrapId, String agreementId) throws ApiException {
        ApiResponse<UserAgreementResponse> localVarResponse = this.getAgreementWithHttpInfo(accountId, clickwrapId, agreementId);
        return localVarResponse.getData();
    }

    public ApiResponse<UserAgreementResponse> getAgreementWithHttpInfo(String accountId, String clickwrapId, String agreementId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAgreement");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling getAgreement");
        }
        if (agreementId == null) {
            throw new ApiException(400, "Missing the required parameter 'agreementId' when calling getAgreement");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/agreements/{agreementId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString())).replaceAll("\\{agreementId\\}", this.apiClient.escapeString(agreementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserAgreementResponse> localVarReturnType = new GenericType<UserAgreementResponse>(){};
        UserAgreementResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UserAgreementResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Document getAgreementDocument(String accountId, String clickwrapId, String versionId, String orderOrDisclosure) throws ApiException {
        ApiResponse<Document> localVarResponse = this.getAgreementDocumentWithHttpInfo(accountId, clickwrapId, versionId, orderOrDisclosure);
        return localVarResponse.getData();
    }

    public ApiResponse<Document> getAgreementDocumentWithHttpInfo(String accountId, String clickwrapId, String versionId, String orderOrDisclosure) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAgreementDocument");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling getAgreementDocument");
        }
        if (versionId == null) {
            throw new ApiException(400, "Missing the required parameter 'versionId' when calling getAgreementDocument");
        }
        if (orderOrDisclosure == null) {
            throw new ApiException(400, "Missing the required parameter 'orderOrDisclosure' when calling getAgreementDocument");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions/{versionId}/documents/{orderOrDisclosure}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString())).replaceAll("\\{versionId\\}", this.apiClient.escapeString(versionId.toString())).replaceAll("\\{orderOrDisclosure\\}", this.apiClient.escapeString(orderOrDisclosure.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Document> localVarReturnType = new GenericType<Document>(){};
        Document localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Document>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public byte[] getAgreementPdf(String accountId, String clickwrapId, String agreementId) throws ApiException {
        return this.getAgreementPdf(accountId, clickwrapId, agreementId, null);
    }

    public byte[] getAgreementPdf(String accountId, String clickwrapId, String agreementId, GetAgreementPdfOptions options) throws ApiException {
        ApiResponse<byte[]> localVarResponse = this.getAgreementPdfWithHttpInfo(accountId, clickwrapId, agreementId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<byte[]> getAgreementPdfWithHttpInfo(String accountId, String clickwrapId, String agreementId, GetAgreementPdfOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAgreementPdf");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling getAgreementPdf");
        }
        if (agreementId == null) {
            throw new ApiException(400, "Missing the required parameter 'agreementId' when calling getAgreementPdf");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/agreements/{agreementId}/download".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString())).replaceAll("\\{agreementId\\}", this.apiClient.escapeString(agreementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_coc", options.includeCoc));
        }
        String[] localVarAccepts = new String[]{"application/pdf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<byte[]> localVarReturnType = new GenericType<byte[]>(){};
        byte[] localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<byte[]>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ClickwrapVersionResponse getClickwrap(String accountId, String clickwrapId) throws ApiException {
        ApiResponse<ClickwrapVersionResponse> localVarResponse = this.getClickwrapWithHttpInfo(accountId, clickwrapId);
        return localVarResponse.getData();
    }

    public ApiResponse<ClickwrapVersionResponse> getClickwrapWithHttpInfo(String accountId, String clickwrapId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getClickwrap");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling getClickwrap");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionResponse> localVarReturnType = new GenericType<ClickwrapVersionResponse>(){};
        ClickwrapVersionResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ClickwrapVersionResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ClickwrapAgreementsResponse getClickwrapAgreements(String accountId, String clickwrapId) throws ApiException {
        return this.getClickwrapAgreements(accountId, clickwrapId, null);
    }

    public ClickwrapAgreementsResponse getClickwrapAgreements(String accountId, String clickwrapId, GetClickwrapAgreementsOptions options) throws ApiException {
        ApiResponse<ClickwrapAgreementsResponse> localVarResponse = this.getClickwrapAgreementsWithHttpInfo(accountId, clickwrapId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<ClickwrapAgreementsResponse> getClickwrapAgreementsWithHttpInfo(String accountId, String clickwrapId, GetClickwrapAgreementsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getClickwrapAgreements");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling getClickwrapAgreements");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/users".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("client_user_id", options.clientUserId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from_date", options.fromDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_number", options.pageNumber));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", options.status));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to_date", options.toDate));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapAgreementsResponse> localVarReturnType = new GenericType<ClickwrapAgreementsResponse>(){};
        ClickwrapAgreementsResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ClickwrapAgreementsResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ClickwrapVersionResponse getClickwrapVersion(String accountId, String clickwrapId, String versionId) throws ApiException {
        ApiResponse<ClickwrapVersionResponse> localVarResponse = this.getClickwrapVersionWithHttpInfo(accountId, clickwrapId, versionId);
        return localVarResponse.getData();
    }

    public ApiResponse<ClickwrapVersionResponse> getClickwrapVersionWithHttpInfo(String accountId, String clickwrapId, String versionId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getClickwrapVersion");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling getClickwrapVersion");
        }
        if (versionId == null) {
            throw new ApiException(400, "Missing the required parameter 'versionId' when calling getClickwrapVersion");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions/{versionId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString())).replaceAll("\\{versionId\\}", this.apiClient.escapeString(versionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionResponse> localVarReturnType = new GenericType<ClickwrapVersionResponse>(){};
        ClickwrapVersionResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ClickwrapVersionResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ClickwrapAgreementsResponse getClickwrapVersionAgreements(String accountId, String clickwrapId, String versionId) throws ApiException {
        return this.getClickwrapVersionAgreements(accountId, clickwrapId, versionId, null);
    }

    public ClickwrapAgreementsResponse getClickwrapVersionAgreements(String accountId, String clickwrapId, String versionId, GetClickwrapVersionAgreementsOptions options) throws ApiException {
        ApiResponse<ClickwrapAgreementsResponse> localVarResponse = this.getClickwrapVersionAgreementsWithHttpInfo(accountId, clickwrapId, versionId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<ClickwrapAgreementsResponse> getClickwrapVersionAgreementsWithHttpInfo(String accountId, String clickwrapId, String versionId, GetClickwrapVersionAgreementsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getClickwrapVersionAgreements");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling getClickwrapVersionAgreements");
        }
        if (versionId == null) {
            throw new ApiException(400, "Missing the required parameter 'versionId' when calling getClickwrapVersionAgreements");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions/{versionId}/users".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString())).replaceAll("\\{versionId\\}", this.apiClient.escapeString(versionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("client_user_id", options.clientUserId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from_date", options.fromDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_number", options.pageNumber));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", options.status));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to_date", options.toDate));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapAgreementsResponse> localVarReturnType = new GenericType<ClickwrapAgreementsResponse>(){};
        ClickwrapAgreementsResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ClickwrapAgreementsResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ClickwrapVersionsPagedResponse getClickwrapVersions(String accountId, String clickwrapId) throws ApiException {
        ApiResponse<ClickwrapVersionsPagedResponse> localVarResponse = this.getClickwrapVersionsWithHttpInfo(accountId, clickwrapId);
        return localVarResponse.getData();
    }

    public ApiResponse<ClickwrapVersionsPagedResponse> getClickwrapVersionsWithHttpInfo(String accountId, String clickwrapId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getClickwrapVersions");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling getClickwrapVersions");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionsPagedResponse> localVarReturnType = new GenericType<ClickwrapVersionsPagedResponse>(){};
        ClickwrapVersionsPagedResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ClickwrapVersionsPagedResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ClickwrapVersionsResponse getClickwraps(String accountId) throws ApiException {
        return this.getClickwraps(accountId, null);
    }

    public ClickwrapVersionsResponse getClickwraps(String accountId, GetClickwrapsOptions options) throws ApiException {
        ApiResponse<ClickwrapVersionsResponse> localVarResponse = this.getClickwrapsWithHttpInfo(accountId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<ClickwrapVersionsResponse> getClickwrapsWithHttpInfo(String accountId, GetClickwrapsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getClickwraps");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", options.filter));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from_date", options.fromDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("name", options.name));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ownerUserId", options.ownerUserId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_number", options.pageNumber));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", options.status));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to_date", options.toDate));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionsResponse> localVarReturnType = new GenericType<ClickwrapVersionsResponse>(){};
        ClickwrapVersionsResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ClickwrapVersionsResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ServiceInformation getServiceInformation() throws ApiException {
        ApiResponse<ServiceInformation> localVarResponse = this.getServiceInformationWithHttpInfo();
        return localVarResponse.getData();
    }

    public ApiResponse<ServiceInformation> getServiceInformationWithHttpInfo() throws ApiException {
        String localVarPostBody = "{}";
        String localVarPath = "/service_information";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ServiceInformation> localVarReturnType = new GenericType<ServiceInformation>(){};
        ServiceInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ServiceInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ClickwrapVersionSummaryResponse updateClickwrap(String accountId, String clickwrapId, ClickwrapTransferRequest clickwrapTransferRequest) throws ApiException {
        ApiResponse<ClickwrapVersionSummaryResponse> localVarResponse = this.updateClickwrapWithHttpInfo(accountId, clickwrapId, clickwrapTransferRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<ClickwrapVersionSummaryResponse> updateClickwrapWithHttpInfo(String accountId, String clickwrapId, ClickwrapTransferRequest clickwrapTransferRequest) throws ApiException {
        ClickwrapTransferRequest localVarPostBody = clickwrapTransferRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateClickwrap");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling updateClickwrap");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionSummaryResponse> localVarReturnType = new GenericType<ClickwrapVersionSummaryResponse>(){};
        ClickwrapVersionSummaryResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ClickwrapVersionSummaryResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ClickwrapVersionSummaryResponse updateClickwrapVersion(String accountId, String clickwrapId, String versionId, ClickwrapRequest clickwrapRequest) throws ApiException {
        ApiResponse<ClickwrapVersionSummaryResponse> localVarResponse = this.updateClickwrapVersionWithHttpInfo(accountId, clickwrapId, versionId, clickwrapRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<ClickwrapVersionSummaryResponse> updateClickwrapVersionWithHttpInfo(String accountId, String clickwrapId, String versionId, ClickwrapRequest clickwrapRequest) throws ApiException {
        ClickwrapRequest localVarPostBody = clickwrapRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateClickwrapVersion");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling updateClickwrapVersion");
        }
        if (versionId == null) {
            throw new ApiException(400, "Missing the required parameter 'versionId' when calling updateClickwrapVersion");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions/{versionId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString())).replaceAll("\\{versionId\\}", this.apiClient.escapeString(versionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionSummaryResponse> localVarReturnType = new GenericType<ClickwrapVersionSummaryResponse>(){};
        ClickwrapVersionSummaryResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ClickwrapVersionSummaryResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public class GetClickwrapsOptions {
        private String filter = null;
        private String fromDate = null;
        private String name = null;
        private String ownerUserId = null;
        private String pageNumber = null;
        private String status = null;
        private String toDate = null;

        public void setFilter(String filter) {
            this.filter = filter;
        }

        public String getFilter() {
            return this.filter;
        }

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setOwnerUserId(String ownerUserId) {
            this.ownerUserId = ownerUserId;
        }

        public String getOwnerUserId() {
            return this.ownerUserId;
        }

        public void setPageNumber(String pageNumber) {
            this.pageNumber = pageNumber;
        }

        public String getPageNumber() {
            return this.pageNumber;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }
    }

    public class GetClickwrapVersionAgreementsOptions {
        private String clientUserId = null;
        private String fromDate = null;
        private String pageNumber = null;
        private String status = null;
        private String toDate = null;

        public void setClientUserId(String clientUserId) {
            this.clientUserId = clientUserId;
        }

        public String getClientUserId() {
            return this.clientUserId;
        }

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setPageNumber(String pageNumber) {
            this.pageNumber = pageNumber;
        }

        public String getPageNumber() {
            return this.pageNumber;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }
    }

    public class GetClickwrapAgreementsOptions {
        private String clientUserId = null;
        private String fromDate = null;
        private String pageNumber = null;
        private String status = null;
        private String toDate = null;

        public void setClientUserId(String clientUserId) {
            this.clientUserId = clientUserId;
        }

        public String getClientUserId() {
            return this.clientUserId;
        }

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setPageNumber(String pageNumber) {
            this.pageNumber = pageNumber;
        }

        public String getPageNumber() {
            return this.pageNumber;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }
    }

    public class GetAgreementPdfOptions {
        private String includeCoc = null;

        public void setIncludeCoc(String includeCoc) {
            this.includeCoc = includeCoc;
        }

        public String getIncludeCoc() {
            return this.includeCoc;
        }
    }

    public class DeleteClickwrapsOptions {
        private String clickwrapIds = null;

        public void setClickwrapIds(String clickwrapIds) {
            this.clickwrapIds = clickwrapIds;
        }

        public String getClickwrapIds() {
            return this.clickwrapIds;
        }
    }

    public class DeleteClickwrapVersionsOptions {
        private String clickwrapVersionIds = null;

        public void setClickwrapVersionIds(String clickwrapVersionIds) {
            this.clickwrapVersionIds = clickwrapVersionIds;
        }

        public String getClickwrapVersionIds() {
            return this.clickwrapVersionIds;
        }
    }

    public class DeleteClickwrapOptions {
        private String versions = null;

        public void setVersions(String versions) {
            this.versions = versions;
        }

        public String getVersions() {
            return this.versions;
        }
    }
}

