/*
 * Decompiled with CFR 0.152.
 */
package com.discord4j.fsm;

import com.discord4j.fsm.EventHandler;
import com.discord4j.fsm.HandlerKey;
import com.discord4j.fsm.StateMachineDSL;
import com.discord4j.fsm.UnhandledTransitionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class FiniteStateMachine<S, E> {
    private final Map<HandlerKey<S, E>, List<EventHandler<S, E, S>>> transitionHandlers = new HashMap<HandlerKey<S, E>, List<EventHandler<S, E, S>>>();
    private Function<? super E, ? extends S> fallbackHandler;
    private S currentState;

    public void startWith(S initialState) {
        this.currentState = initialState;
    }

    public <U extends S> StateMachineDSL<S, E, U> when(Class<U> fromState) {
        return new StateMachineDSL(this, fromState);
    }

    public StateMachineDSL<S, E, S> whenAny() {
        return new StateMachineDSL(this, null);
    }

    public void onUnhandled(Function<? super E, ? extends S> fallbackHandler) {
        this.fallbackHandler = fallbackHandler;
    }

    public void onEvent(E event) {
        if (this.currentState == null) {
            throw new IllegalStateException("Attempt to trigger event before setting initial state");
        }
        HandlerKey<Object, ?> key = new HandlerKey(this.currentState.getClass(), event.getClass());
        List handlers = this.transitionHandlers.getOrDefault(key, Collections.emptyList());
        for (EventHandler handler : handlers) {
            if (!handler.canHandle(event)) continue;
            this.currentState = handler.handle(this.getCurrentState(), event);
            return;
        }
        key = new HandlerKey(null, event.getClass());
        List anyHandlers = this.transitionHandlers.getOrDefault(key, Collections.emptyList());
        for (EventHandler handler : anyHandlers) {
            if (!handler.canHandle(event)) continue;
            this.currentState = handler.handle(this.getCurrentState(), event);
            return;
        }
        if (this.fallbackHandler == null) {
            throw new UnhandledTransitionException(this.currentState, event);
        }
        this.currentState = this.fallbackHandler.apply(event);
    }

    public S getCurrentState() {
        return this.currentState;
    }

    <C extends E, U extends S> void addHandler(Class<U> from, Class<C> eventType, Predicate<? super C> canHandle, BiFunction<? super U, ? super C, ? extends S> handler) {
        this.transitionHandlers.computeIfAbsent(new HandlerKey<U, C>(from, eventType), key -> new ArrayList()).add(new EventHandler<S, C, U>(handler, canHandle));
    }
}

