/*
 * Decompiled with CFR 0.152.
 */
package com.diogonunes.jcdp.color.impl;

import com.diogonunes.jcdp.color.api.AbstractColoredPrinter;
import com.diogonunes.jcdp.color.api.Ansi;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.fusesource.jansi.AnsiConsole;

public class WindowsColoredPrinter
extends AbstractColoredPrinter {
    public WindowsColoredPrinter() {
        this(new Builder(0, true));
    }

    public WindowsColoredPrinter(Builder builder) {
        this.setLevel(builder._level);
        this.setTimestamping(builder._timestampFlag);
        this.setDateFormat(builder._dateFormat);
        this.setAttribute(builder._attribute);
        this.setForegroundColor(builder._foregroundColor);
        this.setBackgroundColor(builder._backgroundColor);
    }

    @Override
    public void printTimestamp() {
        AnsiConsole.out.print(this.generateCode() + this.getDateFormatted() + " ");
    }

    @Override
    public void printErrorTimestamp() {
        AnsiConsole.err.print(this.generateCode() + this.getDateFormatted() + " ");
    }

    @Override
    public void print(Object msg) {
        if (this.isLoggingTimestamps()) {
            this.printTimestamp();
        } else {
            AnsiConsole.out.print(this.generateCode());
        }
        AnsiConsole.out.print(msg);
    }

    @Override
    public void print(Object msg, Ansi.Attribute attr, Ansi.FColor fg, Ansi.BColor bg) {
        if (this.isLoggingTimestamps()) {
            this.printTimestamp();
        } else {
            AnsiConsole.out.print(this.generateCode(attr, fg, bg));
        }
        AnsiConsole.out.print(msg);
    }

    @Override
    public void println(Object msg) {
        if (this.isLoggingTimestamps()) {
            this.printTimestamp();
        } else {
            AnsiConsole.out.print(this.generateCode());
        }
        AnsiConsole.out.println(msg);
    }

    @Override
    public void println(Object msg, Ansi.Attribute attr, Ansi.FColor fg, Ansi.BColor bg) {
        if (this.isLoggingTimestamps()) {
            this.printTimestamp();
        } else {
            AnsiConsole.out.print(this.generateCode(attr, fg, bg));
        }
        AnsiConsole.out.println(msg);
    }

    @Override
    public void errorPrint(Object msg) {
        if (this.isLoggingTimestamps()) {
            this.printTimestamp();
        } else {
            AnsiConsole.out.print(this.generateCode());
        }
        AnsiConsole.err.print(msg);
    }

    @Override
    public void errorPrint(Object msg, Ansi.Attribute attr, Ansi.FColor fg, Ansi.BColor bg) {
        if (this.isLoggingTimestamps()) {
            this.printTimestamp();
        } else {
            AnsiConsole.out.print(this.generateCode(attr, fg, bg));
        }
        AnsiConsole.err.print(msg);
    }

    @Override
    public void errorPrintln(Object msg) {
        if (this.isLoggingTimestamps()) {
            this.printTimestamp();
        } else {
            AnsiConsole.out.print(this.generateCode());
        }
        AnsiConsole.err.println(msg);
    }

    @Override
    public void errorPrintln(Object msg, Ansi.Attribute attr, Ansi.FColor fg, Ansi.BColor bg) {
        if (this.isLoggingTimestamps()) {
            this.printTimestamp();
        } else {
            AnsiConsole.out.print(this.generateCode(attr, fg, bg));
        }
        AnsiConsole.err.println(msg);
    }

    @Override
    public void debugPrint(Object msg) {
        this.print(msg);
    }

    @Override
    public void debugPrint(Object msg, Ansi.Attribute attr, Ansi.FColor fg, Ansi.BColor bg) {
        this.print(msg, attr, fg, bg);
    }

    @Override
    public void debugPrint(Object msg, int level) {
        if (this.canPrint(level)) {
            this.print(msg);
        }
    }

    @Override
    public void debugPrint(Object msg, int level, Ansi.Attribute attr, Ansi.FColor fg, Ansi.BColor bg) {
        if (this.canPrint(level)) {
            this.print(msg, attr, fg, bg);
        }
    }

    @Override
    public void debugPrintln(Object msg) {
        this.println(msg);
    }

    @Override
    public void debugPrintln(Object msg, Ansi.Attribute attr, Ansi.FColor fg, Ansi.BColor bg) {
        this.println(msg, attr, fg, bg);
    }

    @Override
    public void debugPrintln(Object msg, int level) {
        if (this.canPrint(level)) {
            this.println(msg);
        }
    }

    @Override
    public void debugPrintln(Object msg, int level, Ansi.Attribute attr, Ansi.FColor fg, Ansi.BColor bg) {
        if (this.canPrint(level)) {
            this.println(msg, attr, fg, bg);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " | level: " + this.getLevel() + " | timestamping: " + this.isLoggingTimestamps() + " | Attribute: " + this.getAttribute().name() + " | Foreground color: " + this.getForegroundColor().name() + " | Background color: " + this.getBackgroundColor().name();
    }

    public static class Builder {
        private int _level;
        private boolean _timestampFlag;
        private Ansi.Attribute _attribute = Ansi.Attribute.NONE;
        private Ansi.FColor _foregroundColor = Ansi.FColor.NONE;
        private Ansi.BColor _backgroundColor = Ansi.BColor.NONE;
        private DateFormat _dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        public Builder(int level, boolean tsFlag) {
            this._level = level;
            this._timestampFlag = tsFlag;
        }

        public Builder level(int level) {
            this._level = level;
            return this;
        }

        public Builder timestamping(boolean flag) {
            this._timestampFlag = flag;
            return this;
        }

        public Builder withFormat(DateFormat df) {
            this._dateFormat = df;
            return this;
        }

        public Builder attribute(Ansi.Attribute attr) {
            this._attribute = attr;
            return this;
        }

        public Builder foreground(Ansi.FColor fg) {
            this._foregroundColor = fg;
            return this;
        }

        public Builder background(Ansi.BColor bg) {
            this._backgroundColor = bg;
            return this;
        }

        public WindowsColoredPrinter build() {
            return new WindowsColoredPrinter(this);
        }
    }
}

