/*
 * Decompiled with CFR 0.152.
 */
package com.digitalsanctuary.cf.turnstile.filter;

import com.digitalsanctuary.cf.turnstile.service.TurnstileValidationService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class TurnstileCaptchaFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TurnstileCaptchaFilter.class);
    private final TurnstileValidationService validationService;
    @Value(value="${ds.cf.turnstile.login.submissionPath:/login}")
    private String loginSubmissionPath;
    @Value(value="${ds.cf.turnstile.login.redirectUrl:/login?error=captcha}")
    private String loginRedirectUrl;
    @Value(value="${ds.cf.turnstile.token.parameterName:cf-turnstile-response}")
    private String turnstileTokenParameterName;

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        if (request.getServletPath().equals(this.loginSubmissionPath) && "POST".equalsIgnoreCase(request.getMethod())) {
            String token = request.getParameter(this.turnstileTokenParameterName);
            boolean valid = this.validationService.validateTurnstileResponse(token, this.getClientIp(request));
            if (valid) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                log.warn("Turnstile captcha validation failed for request: {}", (Object)request.getServletPath());
                response.sendRedirect(this.loginRedirectUrl);
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private String getClientIp(HttpServletRequest request) {
        return this.validationService.getClientIpAddress((ServletRequest)request);
    }

    @Generated
    public TurnstileCaptchaFilter(TurnstileValidationService validationService) {
        this.validationService = validationService;
    }
}

