/*
 * Decompiled with CFR 0.152.
 */
package com.digitalsanctuary.cf.turnstile.config;

import com.digitalsanctuary.cf.turnstile.config.TurnstileConfigProperties;
import com.digitalsanctuary.cf.turnstile.service.TurnstileValidationService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestTemplate;

@Configuration
public class TurnstileServiceConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TurnstileServiceConfig.class);
    private final TurnstileConfigProperties properties;

    @Bean
    public RestTemplate turnstileRestTemplate(RestTemplateBuilder builder) {
        return builder.build();
    }

    @Bean
    public TurnstileValidationService turnstileValidationService() {
        return new TurnstileValidationService(this.turnstileRestClient(), this.properties);
    }

    @Bean(name={"turnstileRestClient"})
    public RestClient turnstileRestClient() {
        log.info("Creating Turnstile REST client with endpoint: {}", (Object)this.properties.getUrl());
        return RestClient.builder().baseUrl(this.properties.getUrl()).defaultHeader("Content-Type", new String[]{"application/json"}).defaultHeader("Accept", new String[]{"application/json"}).build();
    }

    @Generated
    public TurnstileServiceConfig(TurnstileConfigProperties properties) {
        this.properties = properties;
    }
}

