/*
 * Decompiled with CFR 0.152.
 */
package com.digitalsanctuary.cf.turnstile.config;

import com.digitalsanctuary.cf.turnstile.config.TurnstileConfigProperties;
import com.digitalsanctuary.cf.turnstile.service.TurnstileValidationService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="ds.cf.turnstile.metrics", name={"health-check-enabled"}, havingValue="true", matchIfMissing=true)
public class TurnstileHealthIndicator
implements HealthIndicator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TurnstileHealthIndicator.class);
    private final TurnstileValidationService validationService;
    private final TurnstileConfigProperties properties;

    public Health health() {
        try {
            if (this.properties.getSecret() == null || this.properties.getSecret().isBlank()) {
                return Health.down().withDetail("reason", (Object)"Turnstile secret key is not configured").build();
            }
            if (this.properties.getUrl() == null || this.properties.getUrl().isBlank()) {
                return Health.down().withDetail("reason", (Object)"Turnstile URL is not configured").build();
            }
            double errorRate = this.validationService.getErrorRate();
            int errorThreshold = this.properties.getMetrics().getErrorThreshold();
            Health.Builder builder = Health.up().withDetail("url", (Object)this.properties.getUrl()).withDetail("validationCount", (Object)this.validationService.getValidationCount()).withDetail("successCount", (Object)this.validationService.getSuccessCount()).withDetail("errorCount", (Object)this.validationService.getErrorCount()).withDetail("errorRate", (Object)String.format("%.2f%%", errorRate)).withDetail("responseTimeAvg", (Object)String.format("%.2fms", this.validationService.getAverageResponseTime()));
            if (errorRate > (double)errorThreshold) {
                return builder.down().withDetail("reason", (Object)("Error rate exceeded threshold: " + errorRate + "% > " + errorThreshold + "%")).build();
            }
            return builder.build();
        }
        catch (Exception e) {
            log.error("Error checking Turnstile service health", (Throwable)e);
            return Health.down((Throwable)e).withDetail("reason", (Object)("Error checking service health: " + e.getMessage())).build();
        }
    }

    @Generated
    public TurnstileHealthIndicator(TurnstileValidationService validationService, TurnstileConfigProperties properties) {
        this.validationService = validationService;
        this.properties = properties;
    }
}

