/*
 * Decompiled with CFR 0.152.
 */
package com.digitalsanctuary.cf.turnstile;

import com.digitalsanctuary.cf.turnstile.config.TurnstileConfigProperties;
import com.digitalsanctuary.cf.turnstile.config.TurnstileHealthIndicator;
import com.digitalsanctuary.cf.turnstile.config.TurnstileMetricsConfig;
import com.digitalsanctuary.cf.turnstile.config.TurnstileServiceConfig;
import com.digitalsanctuary.cf.turnstile.filter.TurnstileCaptchaFilter;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@AutoConfiguration
@Import(value={TurnstileServiceConfig.class, TurnstileConfigProperties.class, TurnstileCaptchaFilter.class})
public class TurnstileConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TurnstileConfiguration.class);

    @PostConstruct
    public void onStartup() {
        log.info("DigitalSanctuary Spring Cloudflare Turnstile Service loaded");
    }

    @Configuration
    @ConditionalOnEnabledHealthIndicator(value="turnstile")
    @ConditionalOnClass(name={"org.springframework.boot.actuate.health.HealthIndicator"})
    @Import(value={TurnstileHealthIndicator.class})
    static class TurnstileHealthConfiguration {
        TurnstileHealthConfiguration() {
        }
    }

    @Configuration
    @ConditionalOnClass(value={MeterRegistry.class})
    @Import(value={TurnstileMetricsConfig.class})
    static class TurnstileMetricsConfiguration {
        TurnstileMetricsConfiguration() {
        }
    }
}

