/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.Errors;
import com.diffplug.common.io.ByteStreams;
import com.diffplug.gradle.spotless.GitRatchetGradle;
import com.diffplug.gradle.spotless.GradleCompat;
import com.diffplug.gradle.spotless.SpotlessTaskImpl;
import com.diffplug.spotless.DirtyState;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.NoLambda;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;

final class IdeHook {
    static final String PROPERTY = "spotlessIdeHook";
    static final String USE_STD_IN = "spotlessIdeHookUseStdIn";
    static final String USE_STD_OUT = "spotlessIdeHookUseStdOut";

    private static void dumpIsClean() {
        System.err.println("IS CLEAN");
    }

    static void performHook(SpotlessTaskImpl spotlessTask, State state) {
        if (state.paths == null) {
            return;
        }
        if (state.paths.size() > 1 && (state.useStdIn || state.useStdOut)) {
            System.err.println("Using spotlessIdeHookUseStdIn or spotlessIdeHookUseStdOut with multiple files is not supported");
            return;
        }
        List<File> files = state.paths.stream().map(File::new).toList();
        for (File file2 : files) {
            if (file2.isAbsolute()) continue;
            System.err.println("Argument passed to spotlessIdeHook must be one or multiple absolute paths");
            return;
        }
        List<File> matchedFiles = files.stream().filter(file -> spotlessTask.getTarget().contains(file)).toList();
        for (File file3 : matchedFiles) {
            GitRatchetGradle ratchet = spotlessTask.getRatchet();
            try {
                Formatter formatter = spotlessTask.buildFormatter();
                try {
                    if (ratchet != null && ratchet.isClean(((Directory)spotlessTask.getProjectDir().get()).getAsFile(), spotlessTask.getRootTreeSha(), file3)) {
                        IdeHook.dumpIsClean();
                        continue;
                    }
                    byte[] bytes = state.useStdIn ? ByteStreams.toByteArray((InputStream)System.in) : Files.readAllBytes(file3.toPath());
                    DirtyState dirty = DirtyState.of((Formatter)formatter, (File)file3, (byte[])bytes);
                    if (dirty.isClean()) {
                        IdeHook.dumpIsClean();
                        continue;
                    }
                    if (dirty.didNotConverge()) {
                        System.err.println("DID NOT CONVERGE");
                        System.err.println("Run 'spotlessDiagnose' for details https://github.com/diffplug/spotless/blob/main/PADDEDCELL.md");
                        continue;
                    }
                    System.err.println("IS DIRTY");
                    if (state.useStdOut) {
                        dirty.writeCanonicalTo((OutputStream)System.out);
                        continue;
                    }
                    dirty.writeCanonicalTo(file3);
                }
                finally {
                    if (formatter == null) continue;
                    formatter.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                throw Errors.asRuntime((Throwable)e);
            }
            finally {
                System.err.close();
                System.out.close();
            }
        }
    }

    private IdeHook() {
    }

    static class State
    extends NoLambda.EqualityBasedOnSerialization {
        @Nullable
        final List<String> paths;
        final boolean useStdIn;
        final boolean useStdOut;

        State(Project project) {
            String pathsString = GradleCompat.findOptionalProperty(project, IdeHook.PROPERTY);
            if (pathsString != null) {
                this.useStdIn = GradleCompat.isPropertyPresent(project, IdeHook.USE_STD_IN);
                this.useStdOut = GradleCompat.isPropertyPresent(project, IdeHook.USE_STD_OUT);
                this.paths = Arrays.stream(pathsString.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            } else {
                this.useStdIn = false;
                this.useStdOut = false;
                this.paths = null;
            }
        }
    }
}

