/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.Unhandled;
import com.diffplug.common.collect.ImmutableList;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.extra.P2ModelWrapper;
import com.diffplug.spotless.extra.P2Provisioner;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.java.TargetJvmEnvironment;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GradleProvisioner {
    private static final Logger LOGGER = LoggerFactory.getLogger(GradleProvisioner.class);

    private GradleProvisioner() {
    }

    static Provisioner forProject(Project project) {
        return GradleProvisioner.forConfigurationContainer(project, project.getConfigurations(), project.getDependencies());
    }

    static Provisioner forRootProjectBuildscript(Project project) {
        Project rootProject = project.getRootProject();
        ScriptHandler buildscript = rootProject.getBuildscript();
        return GradleProvisioner.forConfigurationContainer(rootProject, buildscript.getConfigurations(), buildscript.getDependencies());
    }

    private static Provisioner forConfigurationContainer(Project project, ConfigurationContainer configurations, DependencyHandler dependencies) {
        return (withTransitives, mavenCoords) -> {
            try {
                Configuration config = (Configuration)configurations.create("spotless" + new Request(withTransitives, mavenCoords).hashCode());
                mavenCoords.stream().map(arg_0 -> ((DependencyHandler)dependencies).create(arg_0)).forEach(arg_0 -> config.getDependencies().add(arg_0));
                config.setDescription(mavenCoords.toString());
                config.setTransitive(withTransitives);
                config.setCanBeConsumed(false);
                config.setVisible(false);
                config.attributes(attr -> {
                    attr.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)project.getObjects().named(Category.class, "library")));
                    attr.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)project.getObjects().named(Bundling.class, "external")));
                    attr.attribute(TargetJvmEnvironment.TARGET_JVM_ENVIRONMENT_ATTRIBUTE, (Object)((TargetJvmEnvironment)project.getObjects().named(TargetJvmEnvironment.class, "standard-jvm")));
                });
                return config.resolve();
            }
            catch (Exception e) {
                Object projName = project.getPath().substring(1).replace(':', '/');
                if (!((String)projName).isEmpty()) {
                    projName = (String)projName + "/";
                }
                throw new GradleException(String.format("You need to add a repository containing the '%s' artifact in '%sbuild.gradle'.%nE.g.: 'repositories { mavenCentral() }'", mavenCoords, projName), (Throwable)e);
            }
        };
    }

    private static class Request {
        final boolean withTransitives;
        final ImmutableList<String> mavenCoords;

        public Request(boolean withTransitives, Collection<String> mavenCoords) {
            this.withTransitives = withTransitives;
            this.mavenCoords = ImmutableList.copyOf(mavenCoords);
        }

        public int hashCode() {
            return this.withTransitives ? this.mavenCoords.hashCode() : ~this.mavenCoords.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Request) {
                Request o = (Request)obj;
                return o.withTransitives == this.withTransitives && o.mavenCoords.equals(this.mavenCoords);
            }
            return false;
        }

        public String toString() {
            String coords = this.mavenCoords.toString();
            StringBuilder builder = new StringBuilder();
            builder.append(coords, 1, coords.length() - 1);
            if (this.withTransitives) {
                builder.append(" with transitives");
            } else {
                builder.append(" no transitives");
            }
            return builder.toString();
        }
    }

    static class DedupingP2Provisioner
    implements P2Provisioner {
        private final Map<P2Request, List<File>> cache = new HashMap<P2Request, List<File>>();
        private final P2Provisioner p2Provisioner;
        final P2Provisioner cachedOnly = (modelWrapper, mavenProvisioner, cacheDirectory) -> {
            List<File> result;
            P2Request req = new P2Request(List.copyOf(modelWrapper.getP2Repos()), List.copyOf(modelWrapper.getInstallList()), Set.copyOf(modelWrapper.getFilterNames()), List.copyOf(modelWrapper.getPureMaven()), modelWrapper.isUseMavenCentral(), cacheDirectory);
            Map<P2Request, List<File>> map = this.cache;
            synchronized (map) {
                result = this.cache.get(req);
            }
            if (result != null) {
                return result;
            }
            throw new GradleException("P2 dependencies not predeclared. Add Eclipse formatter configuration to the `spotlessPredeclare` block in the root project.");
        };

        public DedupingP2Provisioner(P2Provisioner p2Provisioner) {
            this.p2Provisioner = p2Provisioner;
        }

        public synchronized List<File> provisionP2Dependencies(P2ModelWrapper modelWrapper, Provisioner mavenProvisioner, @Nullable File cacheDirectory) throws IOException {
            P2Request req = new P2Request(List.copyOf(modelWrapper.getP2Repos()), List.copyOf(modelWrapper.getInstallList()), Set.copyOf(modelWrapper.getFilterNames()), List.copyOf(modelWrapper.getPureMaven()), modelWrapper.isUseMavenCentral(), cacheDirectory);
            List result = this.cache.get(req);
            if (result != null) {
                return result;
            }
            result = this.p2Provisioner.provisionP2Dependencies(modelWrapper, mavenProvisioner, cacheDirectory);
            this.cache.put(req, List.copyOf(result));
            return result;
        }

        private record P2Request(List<String> p2Repos, List<String> installList, Set<String> filterNames, List<String> pureMaven, boolean useMavenCentral, @Nullable File cacheDirectory) {
        }
    }

    static class DedupingProvisioner
    implements Provisioner {
        private final Provisioner provisioner;
        private final Map<Request, Set<File>> cache = new HashMap<Request, Set<File>>();
        final Provisioner cachedOnly = (withTransitives, mavenCoordinates) -> {
            Set<File> result;
            Request req = new Request(withTransitives, mavenCoordinates);
            Map<Request, Set<File>> map = this.cache;
            synchronized (map) {
                result = this.cache.get(req);
            }
            if (result != null) {
                return result;
            }
            throw new GradleException("Add a step with " + String.valueOf(req.mavenCoords) + " into the `spotlessPredeclare` block in the root project.");
        };

        DedupingProvisioner(Provisioner provisioner) {
            this.provisioner = provisioner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<File> provisionWithTransitives(boolean withTransitives, Collection<String> mavenCoordinates) {
            Set result;
            Request req = new Request(withTransitives, mavenCoordinates);
            Map<Request, Set<File>> map = this.cache;
            synchronized (map) {
                result = this.cache.get(req);
            }
            if (result != null) {
                return result;
            }
            map = this.cache;
            synchronized (map) {
                result = this.cache.get(req);
                if (result == null) {
                    result = this.provisioner.provisionWithTransitives(req.withTransitives, req.mavenCoords);
                    this.cache.put(req, result);
                }
                return result;
            }
        }
    }

    static enum Policy {
        INDEPENDENT,
        ROOT_PROJECT,
        ROOT_BUILDSCRIPT;


        public DedupingProvisioner dedupingProvisioner(Project project) {
            return switch (this.ordinal()) {
                case 1 -> new DedupingProvisioner(GradleProvisioner.forProject(project));
                case 2 -> new DedupingProvisioner(GradleProvisioner.forRootProjectBuildscript(project));
                default -> throw Unhandled.enumException((Enum)this);
            };
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public DedupingP2Provisioner dedupingP2Provisioner(Project project) {
            switch (this.ordinal()) {
                case 1: 
                case 2: {
                    return new DedupingP2Provisioner(P2Provisioner.createDefault());
                }
                default: {
                    throw Unhandled.enumException((Enum)this);
                }
            }
        }
    }
}

