/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.PluginGradlePreconditions;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.extra.EquoBasedStepBuilder;
import com.diffplug.spotless.extra.groovy.GrEclipseFormatterStep;
import com.diffplug.spotless.groovy.RemoveSemicolonsStep;
import com.diffplug.spotless.java.ImportOrderStep;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.gradle.api.Project;

public abstract class BaseGroovyExtension
extends FormatExtension {
    protected BaseGroovyExtension(SpotlessExtension spotless) {
        super(spotless);
    }

    public void importOrder(String ... importOrder) {
        this.addStep(ImportOrderStep.forGroovy().createFrom(importOrder));
    }

    public void importOrderFile(Object importOrderFile) {
        Objects.requireNonNull(importOrderFile);
        this.addStep(ImportOrderStep.forGroovy().createFrom(this.getProject().file(importOrderFile)));
    }

    public void removeSemicolons() {
        this.addStep(RemoveSemicolonsStep.create());
    }

    public GrEclipseConfig greclipse() {
        return this.greclipse(GrEclipseFormatterStep.defaultVersion());
    }

    public GrEclipseConfig greclipse(String version) {
        return new GrEclipseConfig(version, this);
    }

    public static final class GrEclipseConfig {
        private final EquoBasedStepBuilder builder;
        private final FormatExtension extension;

        private GrEclipseConfig(String version, FormatExtension extension) {
            this.extension = extension;
            this.builder = GrEclipseFormatterStep.createBuilder((Provisioner)extension.provisioner());
            this.builder.setVersion(version);
            extension.addStep(this.builder.build());
        }

        public GrEclipseConfig configFile(Object ... configFiles) {
            PluginGradlePreconditions.requireElementsNonNull(configFiles);
            Project project = this.extension.getProject();
            this.builder.setPreferences((Iterable)project.files(configFiles).getFiles());
            this.extension.replaceStep(this.builder.build());
            return this;
        }

        public GrEclipseConfig configProperties(String ... configs) {
            PluginGradlePreconditions.requireElementsNonNull(configs);
            this.builder.setPropertyPreferences(List.of(configs));
            this.extension.replaceStep(this.builder.build());
            return this;
        }

        public GrEclipseConfig configXml(String ... configs) {
            PluginGradlePreconditions.requireElementsNonNull(configs);
            this.builder.setXmlPreferences(List.of(configs));
            this.extension.replaceStep(this.builder.build());
            return this;
        }

        public GrEclipseConfig withP2Mirrors(Map<String, String> mirrors) {
            this.builder.setP2Mirrors(mirrors);
            this.extension.replaceStep(this.builder.build());
            return this;
        }
    }
}

