/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.Errors;
import com.diffplug.common.base.Preconditions;
import com.diffplug.common.io.FileWriteMode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

class SerializableMisc {
    SerializableMisc() {
    }

    static void toFile(Serializable obj, File file) {
        try {
            Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
            try (OutputStream output = com.diffplug.common.io.Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]).openBufferedStream();){
                SerializableMisc.toStream(obj, output);
            }
        }
        catch (IOException e) {
            throw Errors.asRuntime((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> T fromFile(Class<T> clazz, File file) {
        try (InputStream input = com.diffplug.common.io.Files.asByteSource((File)file).openBufferedStream();){
            T t = SerializableMisc.fromStream(clazz, input);
            return t;
        }
        catch (IOException e) {
            throw Errors.asRuntime((Throwable)e);
        }
    }

    static void toStream(Serializable obj, OutputStream stream) {
        try (ObjectOutputStream objectOutput = new ObjectOutputStream(stream);){
            objectOutput.writeObject(obj);
        }
        catch (IOException e) {
            throw Errors.asRuntime((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> T fromStream(Class<T> clazz, InputStream stream) {
        try (ObjectInputStream objectInput = new ObjectInputStream(stream);){
            Object object = objectInput.readObject();
            Preconditions.checkArgument((boolean)clazz.isInstance(object), (String)"Requires class %s, was %s", (Object[])new Object[]{clazz, object});
            Object object2 = object;
            return (T)object2;
        }
        catch (IOException | ClassNotFoundException e) {
            throw Errors.asRuntime((Throwable)e);
        }
    }
}

