/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessExtensionImpl;
import com.diffplug.gradle.spotless.SpotlessPluginRedirect;
import com.diffplug.spotless.Jvm;
import com.diffplug.spotless.SpotlessCache;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.BasePlugin;

public class SpotlessPlugin
implements Plugin<Project> {
    static final String SPOTLESS_MODERN = "spotlessModern";
    static final String VER_GRADLE_min = "6.1.1";
    static final String VER_GRADLE_javaPluginExtension = "7.1";
    private static final int MINIMUM_JRE = 11;

    public void apply(Project project) {
        if (SpotlessPluginRedirect.gradleIsTooOld(project)) {
            throw new GradleException("Spotless requires Gradle 6.1.1 or newer, this was " + project.getGradle().getGradleVersion());
        }
        if (Jvm.version() < 11) {
            throw new GradleException("Spotless requires JRE 11 or newer, this was " + JavaVersion.current() + ".\nYou can upgrade your build JRE and still compile for older targets, see below\nhttps://docs.gradle.org/current/userguide/building_java_projects.html#sec:java_cross_compilation");
        }
        if (project.hasProperty(SPOTLESS_MODERN)) {
            project.getLogger().warn("'spotlessModern' has no effect as of Spotless 5.0, recommend removing it.");
        }
        project.getPlugins().apply(BasePlugin.class);
        project.getExtensions().create(SpotlessExtension.class, "spotless", SpotlessExtensionImpl.class, new Object[]{project});
        int cacheKey = System.identityHashCode(project.getRootProject());
        project.getTasks().named("clean").configure(clean -> clean.doLast(unused -> SpotlessCache.clearOnce((Object)cacheKey)));
    }

    static String capitalize(String input) {
        return Character.toUpperCase(input.charAt(0)) + input.substring(1);
    }
}

