/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.rome.RomeStep;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;

public abstract class RomeStepConfig<Self extends RomeStepConfig<Self>> {
    @Nullable
    private Object configPath;
    @Nullable
    private Object downloadDir;
    @Nullable
    private Object pathToExe;
    private final Project project;
    private final Consumer<FormatterStep> replaceStep;
    @Nullable
    private String version;

    protected RomeStepConfig(Project project, Consumer<FormatterStep> replaceStep, String version) {
        this.project = Objects.requireNonNull(project);
        this.replaceStep = Objects.requireNonNull(replaceStep);
        this.version = version;
    }

    public Self configPath(Object configPath) {
        this.configPath = configPath;
        this.replaceStep();
        return this.getThis();
    }

    public Self downloadDir(Object downloadDir) {
        this.downloadDir = downloadDir;
        this.replaceStep();
        return this.getThis();
    }

    public Self pathToExe(Object pathToExe) {
        this.pathToExe = pathToExe;
        this.replaceStep();
        return this.getThis();
    }

    protected FormatterStep createStep() {
        RomeStep builder = this.newBuilder();
        if (this.configPath != null) {
            File resolvedConfigPath = this.project.file(this.configPath);
            builder.withConfigPath(resolvedConfigPath.toString());
        }
        builder.withLanguage(this.getLanguage());
        return builder.create();
    }

    protected abstract String getLanguage();

    protected abstract Self getThis();

    protected void replaceStep() {
        this.replaceStep.accept(this.createStep());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File findDataDir() {
        MavenArtifactRepository currentRepo = this.project.getRepositories().stream().filter(r -> r instanceof MavenArtifactRepository).map(r -> (MavenArtifactRepository)r).filter(r -> "file".equals(r.getUrl().getScheme())).findAny().orElse(null);
        MavenArtifactRepository localRepo = currentRepo != null ? currentRepo : this.project.getRepositories().mavenLocal();
        try {
            Path repoPath = Path.of(localRepo.getUrl());
            Path dataPath = repoPath.resolve("com").resolve("diffplug").resolve("spotless").resolve("spotless-data");
            File file = dataPath.toAbsolutePath().toFile();
            return file;
        }
        finally {
            if (currentRepo == null) {
                this.project.getRepositories().remove((Object)localRepo);
            }
        }
    }

    private RomeStep newBuilder() {
        if (this.pathToExe != null) {
            String resolvedPathToExe = this.resolvePathToExe();
            return RomeStep.withExePath((String)resolvedPathToExe);
        }
        String downloadDir = this.resolveDownloadDir();
        return RomeStep.withExeDownload((String)this.version, (String)downloadDir);
    }

    private String resolvePathToExe() {
        boolean fileNameOnly;
        boolean bl = fileNameOnly = this.pathToExe instanceof String && Paths.get(this.pathToExe.toString(), new String[0]).getNameCount() == 1;
        if (fileNameOnly) {
            return this.pathToExe.toString();
        }
        return this.project.file(this.pathToExe).toString();
    }

    private String resolveDownloadDir() {
        if (this.downloadDir != null) {
            return this.project.file(this.downloadDir).toString();
        }
        return this.findDataDir().toPath().resolve("rome").toString();
    }
}

