/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven;

import com.diffplug.spotless.extra.GitRatchet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;

final class GitRatchetMaven
extends GitRatchet<File> {
    Map<Key, Set<String>> cache = new HashMap<Key, Set<String>>();
    private static volatile GitRatchetMaven instance = new GitRatchetMaven();

    private GitRatchetMaven() {
    }

    protected File getDir(File project) {
        return project;
    }

    protected File getParent(File project) {
        return project.getParentFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static GitRatchetMaven instance() {
        if (instance != null) return instance;
        Class<GitRatchetMaven> clazz = GitRatchetMaven.class;
        synchronized (GitRatchetMaven.class) {
            if (instance != null) return instance;
            instance = new GitRatchetMaven();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getDirtyFiles(File baseDir, String ratchetFrom) throws IOException {
        Repository repository = this.repositoryFor(baseDir);
        Set<String> dirtyPaths = null;
        Key key = new Key(repository.getIdentifier(), ratchetFrom);
        GitRatchetMaven gitRatchetMaven = this;
        synchronized (gitRatchetMaven) {
            if (this.cache.containsKey(key)) {
                dirtyPaths = this.cache.get(key);
            } else {
                dirtyPaths = this.getDirtyFilesInternal(repository, baseDir, ratchetFrom);
                this.cache.put(key, dirtyPaths);
            }
        }
        Path baseDirPath = Path.of(baseDir.getPath(), new String[0]);
        String workTreePath = repository.getWorkTree().getPath();
        return dirtyPaths.stream().map(path -> baseDirPath.relativize(Path.of(workTreePath, path)).toString()).collect(Collectors.toList());
    }

    Set<String> getDirtyFilesInternal(Repository repository, File baseDir, String ratchetFrom) throws IOException {
        ObjectId sha = this.rootTreeShaOf(baseDir, ratchetFrom);
        IndexDiff indexDiff = new IndexDiff(repository, sha, (WorkingTreeIterator)new FileTreeIterator(repository));
        indexDiff.diff();
        HashSet<String> dirtyPaths = new HashSet<String>(indexDiff.getChanged());
        dirtyPaths.addAll(indexDiff.getAdded());
        dirtyPaths.addAll(indexDiff.getConflicting());
        dirtyPaths.addAll(indexDiff.getUntracked());
        for (String path : indexDiff.getModified()) {
            if (dirtyPaths.add(path) || !this.isClean(baseDir, sha, path)) continue;
            dirtyPaths.remove(path);
        }
        for (String path : indexDiff.getRemoved()) {
            if (!dirtyPaths.contains(path) || !this.isClean(baseDir, sha, path)) continue;
            dirtyPaths.remove(path);
        }
        dirtyPaths.removeAll(indexDiff.getMissing());
        return dirtyPaths;
    }

    private static final class Key {
        private final String identifier;
        private final String ratchetFrom;

        private Key(String identifier, String ratchetFrom) {
            this.identifier = identifier;
            this.ratchetFrom = ratchetFrom;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.identifier, key.identifier) && Objects.equals(this.ratchetFrom, key.ratchetFrom);
        }

        public int hashCode() {
            return Objects.hash(this.identifier, this.ratchetFrom);
        }
    }
}

