/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven;

import com.diffplug.spotless.GitPrePushHookInstaller;
import com.diffplug.spotless.GitPrePushHookInstallerMaven;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="install-git-pre-push-hook", threadSafe=true)
public class SpotlessInstallPrePushHookMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.project.isExecutionRoot()) {
            this.getLog().debug((CharSequence)("Skipping Spotless pre-push hook installation for non-root project: " + this.project.getName()));
            return;
        }
        GitPrePushHookInstaller.GitPreHookLogger logger = new GitPrePushHookInstaller.GitPreHookLogger(){

            public void info(String format, Object ... arguments) {
                SpotlessInstallPrePushHookMojo.this.getLog().info((CharSequence)format.formatted(arguments));
            }

            public void warn(String format, Object ... arguments) {
                SpotlessInstallPrePushHookMojo.this.getLog().warn((CharSequence)format.formatted(arguments));
            }

            public void error(String format, Object ... arguments) {
                SpotlessInstallPrePushHookMojo.this.getLog().error((CharSequence)format.formatted(arguments));
            }
        };
        try {
            GitPrePushHookInstallerMaven installer = new GitPrePushHookInstallerMaven(logger, this.project.getBasedir());
            installer.install();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to install pre-push hook", e);
        }
    }
}

