/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven.incremental;

import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.maven.incremental.ObjectDigestOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Base64;
import java.util.Objects;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.project.MavenProject;

class PluginFingerprint {
    private static final String SPOTLESS_PLUGIN_KEY = "com.diffplug.spotless:spotless-maven-plugin";
    private final String value;

    private PluginFingerprint(String value) {
        this.value = value;
    }

    static PluginFingerprint from(MavenProject project, Iterable<Formatter> formatters) {
        Plugin spotlessPlugin = PluginFingerprint.findSpotlessPlugin(project);
        byte[] digest = PluginFingerprint.digest(spotlessPlugin, formatters);
        String value = Base64.getEncoder().encodeToString(digest);
        return new PluginFingerprint(value);
    }

    static PluginFingerprint from(String value) {
        return new PluginFingerprint(value);
    }

    static PluginFingerprint empty() {
        return new PluginFingerprint("");
    }

    String value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginFingerprint that = (PluginFingerprint)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "PluginFingerprint[" + this.value + "]";
    }

    private static Plugin findSpotlessPlugin(MavenProject project) {
        PluginManagement pluginManagement;
        Plugin plugin = project.getPlugin(SPOTLESS_PLUGIN_KEY);
        if (plugin == null && (pluginManagement = project.getPluginManagement()) != null) {
            plugin = (Plugin)pluginManagement.getPluginsAsMap().get(SPOTLESS_PLUGIN_KEY);
        }
        if (plugin == null) {
            throw new IllegalArgumentException("Spotless plugin absent from the project: " + String.valueOf(project));
        }
        return plugin;
    }

    private static byte[] digest(Plugin plugin, Iterable<Formatter> formatters) {
        Object object;
        block9: {
            ObjectDigestOutputStream out = ObjectDigestOutputStream.create();
            try {
                out.writeObject(plugin.getVersion());
                for (Formatter formatter : formatters) {
                    out.writeObject(formatter);
                }
                out.flush();
                object = out.digest();
                if (out == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to serialize plugin " + String.valueOf(plugin), e);
                }
            }
            out.close();
        }
        return object;
    }
}

