/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven;

import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.maven.FormatterConfig;
import com.diffplug.spotless.maven.FormatterFactory;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

class FormattersHolder
implements AutoCloseable {
    private final Map<Formatter, Supplier<Iterable<File>>> formatterToFiles;

    FormattersHolder(Map<Formatter, Supplier<Iterable<File>>> formatterToFiles) {
        this.formatterToFiles = formatterToFiles;
    }

    static FormattersHolder create(Map<FormatterFactory, Supplier<Iterable<File>>> formatterFactoryToFiles, FormatterConfig config) {
        LinkedHashMap<Formatter, Supplier<Iterable<File>>> formatterToFiles = new LinkedHashMap<Formatter, Supplier<Iterable<File>>>();
        try {
            for (Map.Entry<FormatterFactory, Supplier<Iterable<File>>> entry : formatterFactoryToFiles.entrySet()) {
                FormatterFactory formatterFactory = entry.getKey();
                Supplier<Iterable<File>> files = entry.getValue();
                Formatter formatter = formatterFactory.newFormatter(files, config);
                formatterToFiles.put(formatter, files);
            }
        }
        catch (RuntimeException openError) {
            try {
                FormattersHolder.close(formatterToFiles.keySet());
            }
            catch (Exception closeError) {
                openError.addSuppressed(closeError);
            }
            throw openError;
        }
        return new FormattersHolder(formatterToFiles);
    }

    Iterable<Formatter> getFormatters() {
        return this.formatterToFiles.keySet();
    }

    Map<Formatter, Supplier<Iterable<File>>> getFormattersWithFiles() {
        return this.formatterToFiles;
    }

    @Override
    public void close() {
        try {
            FormattersHolder.close(this.formatterToFiles.keySet());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to close formatters", e);
        }
    }

    private static void close(Set<Formatter> formatters) throws Exception {
        Exception error = null;
        for (Formatter formatter : formatters) {
            try {
                formatter.close();
            }
            catch (Exception e) {
                if (error == null) {
                    error = e;
                    continue;
                }
                error.addSuppressed(e);
            }
        }
        if (error != null) {
            throw error;
        }
    }
}

