/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.groovy;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import java.io.Serializable;

public final class RemoveSemicolonsStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "Remove unnecessary semicolons";

    private RemoveSemicolonsStep() {
    }

    public static FormatterStep create() {
        return FormatterStep.create(NAME, new State(), State::toFormatter);
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private State() {
        }

        FormatterFunc toFormatter() {
            return raw -> {
                StringBuilder result = new StringBuilder(raw.length());
                boolean inSingleQuoteString = false;
                boolean inDoubleQuoteString = false;
                boolean inTripleSingleQuoteString = false;
                boolean inTripleDoubleQuoteString = false;
                boolean inSingleLineComment = false;
                boolean inMultiLineComment = false;
                boolean escaped = false;
                for (int i = 0; i < raw.length(); ++i) {
                    char c = raw.charAt(i);
                    if (!inSingleLineComment && !inMultiLineComment && i + 2 < raw.length()) {
                        String triple = raw.substring(i, i + 3);
                        if ("'''".equals(triple) && !inDoubleQuoteString && !inTripleDoubleQuoteString) {
                            inTripleSingleQuoteString = !inTripleSingleQuoteString;
                            result.append(triple);
                            i += 2;
                            continue;
                        }
                        if ("\"\"\"".equals(triple) && !inSingleQuoteString && !inTripleSingleQuoteString) {
                            inTripleDoubleQuoteString = !inTripleDoubleQuoteString;
                            result.append(triple);
                            i += 2;
                            continue;
                        }
                    }
                    if (c == '\\' && (inSingleQuoteString || inDoubleQuoteString || inTripleSingleQuoteString || inTripleDoubleQuoteString)) {
                        escaped = !escaped;
                        result.append(c);
                        continue;
                    }
                    if (!(inSingleQuoteString || inDoubleQuoteString || inTripleSingleQuoteString || inTripleDoubleQuoteString || escaped)) {
                        if (c == '/' && i + 1 < raw.length() && raw.charAt(i + 1) == '/' && !inMultiLineComment) {
                            inSingleLineComment = true;
                        } else if (c == '/' && i + 1 < raw.length() && raw.charAt(i + 1) == '*' && !inSingleLineComment) {
                            inMultiLineComment = true;
                        } else if (c == '*' && i + 1 < raw.length() && raw.charAt(i + 1) == '/' && inMultiLineComment) {
                            inMultiLineComment = false;
                            result.append(c);
                            if (i + 1 >= raw.length()) continue;
                            result.append(raw.charAt(i + 1));
                            ++i;
                            continue;
                        }
                    }
                    if (!(inSingleLineComment || inMultiLineComment || escaped)) {
                        if (!(c != '\'' || inDoubleQuoteString || inTripleSingleQuoteString || inTripleDoubleQuoteString)) {
                            inSingleQuoteString = !inSingleQuoteString;
                        } else if (!(c != '\"' || inSingleQuoteString || inTripleSingleQuoteString || inTripleDoubleQuoteString)) {
                            boolean bl = inDoubleQuoteString = !inDoubleQuoteString;
                        }
                    }
                    if ((c == '\n' || c == '\r') && inSingleLineComment) {
                        inSingleLineComment = false;
                    }
                    if (!(c != ';' || inSingleQuoteString || inDoubleQuoteString || inTripleSingleQuoteString || inTripleDoubleQuoteString || inSingleLineComment || inMultiLineComment)) {
                        char next;
                        boolean isEndOfLine = true;
                        for (int j = i + 1; j < raw.length() && (next = raw.charAt(j)) != '\n' && next != '\r'; ++j) {
                            if (Character.isWhitespace(next)) continue;
                            isEndOfLine = false;
                            break;
                        }
                        if (isEndOfLine) continue;
                    }
                    result.append(c);
                    escaped = false;
                }
                return result.toString();
            };
        }
    }
}

