/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.markdown;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.markdown.FlexmarkConfig;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Objects;

public final class FlexmarkStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_VERSION = "0.64.8";
    private static final String MAVEN_COORDINATE = "com.vladsch.flexmark:flexmark-all:";
    public static final String NAME = "flexmark-java";
    private final JarState.Promised jarState;
    private final FlexmarkConfig config;

    private FlexmarkStep(JarState.Promised jarState, FlexmarkConfig config) {
        this.jarState = jarState;
        this.config = config;
    }

    public static FormatterStep create(Provisioner provisioner, FlexmarkConfig config) {
        return FlexmarkStep.create(FlexmarkStep.defaultVersion(), provisioner, config);
    }

    public static FormatterStep create(String version, Provisioner provisioner, FlexmarkConfig config) {
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(provisioner, "provisioner");
        return FormatterStep.create(NAME, new FlexmarkStep(JarState.promise(() -> JarState.from(MAVEN_COORDINATE + version, provisioner)), config), FlexmarkStep::equalityState, State::createFormat);
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    private State equalityState() {
        return new State(this.jarState.get(), this.config);
    }

    private static class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final JarState jarState;
        private final FlexmarkConfig config;

        State(JarState jarState, FlexmarkConfig config) {
            this.jarState = jarState;
            this.config = config;
        }

        FormatterFunc createFormat() throws Exception {
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> formatterFunc = classLoader.loadClass("com.diffplug.spotless.glue.markdown.FlexmarkFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(FlexmarkConfig.class);
            return (FormatterFunc)constructor.newInstance(this.config);
        }
    }
}

