/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.biome;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.ForeignExe;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.ProcessRunner;
import com.diffplug.spotless.biome.BiomeExecutableDownloader;
import com.diffplug.spotless.biome.BiomeSettings;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BiomeStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(BiomeStep.class);
    private String configPath;
    private String language;
    private final String pathToExe;
    private final String downloadDir;
    private final String version;

    public String name() {
        return BiomeSettings.shortName();
    }

    public static BiomeStep withExeDownload(String version, String downloadDir) {
        return new BiomeStep(version, null, downloadDir);
    }

    public static BiomeStep withExePath(String pathToExe) {
        return new BiomeStep(null, pathToExe, null);
    }

    private static void attemptToAddPosixPermission(Path file, PosixFilePermission permission) {
        try {
            HashSet<PosixFilePermission> newPermissions = new HashSet<PosixFilePermission>(Files.getPosixFilePermissions(file, new LinkOption[0]));
            newPermissions.add(permission);
            Files.setPosixFilePermissions(file, newPermissions);
        }
        catch (Exception ignore) {
            LOGGER.debug("Unable to add POSIX permission '{}' to file '{}'", (Object)permission, (Object)file);
        }
    }

    private static String defaultVersion() {
        return BiomeSettings.defaultVersion();
    }

    private static void makeExecutable(String filePath) {
        Path exePath = Path.of(filePath, new String[0]);
        BiomeStep.attemptToAddPosixPermission(exePath, PosixFilePermission.GROUP_EXECUTE);
        BiomeStep.attemptToAddPosixPermission(exePath, PosixFilePermission.OTHERS_EXECUTE);
        BiomeStep.attemptToAddPosixPermission(exePath, PosixFilePermission.OWNER_EXECUTE);
    }

    private static String resolveNameAgainstPath(String name) throws IOException, InterruptedException {
        try (ProcessRunner runner = new ProcessRunner();){
            ProcessRunner.Result cmdWhich = runner.shellWinUnix("where " + name, "which " + name);
            if (cmdWhich.exitNotZero()) {
                throw new IOException("Unable to find " + name + " on path via command " + String.valueOf(cmdWhich));
            }
            String string = cmdWhich.assertExitZero(Charset.defaultCharset()).trim();
            return string;
        }
    }

    private static void validateBiomeConfigPath(String configPath, String version) {
        Path configFile;
        if (configPath == null) {
            return;
        }
        boolean atLeastV2 = BiomeSettings.versionHigherThanOrEqualTo(version, 2, 0, 0);
        Path path = Path.of(configPath, new String[0]);
        Path path2 = configFile = Files.isRegularFile(path, new LinkOption[0]) && atLeastV2 ? path : path.resolve(BiomeSettings.configName());
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Biome config directory does not exist: " + String.valueOf(path));
        }
        if (!Files.exists(configFile, new LinkOption[0])) {
            throw new IllegalArgumentException("Biome config does not exist: " + String.valueOf(configFile));
        }
    }

    private static void validateBiomeExecutable(String resolvedPathToExe) {
        if (!new File(resolvedPathToExe).isFile()) {
            throw new IllegalArgumentException("Biome executable does not exist: " + resolvedPathToExe);
        }
    }

    private BiomeStep(String version, String pathToExe, String downloadDir) {
        this.version = version != null && !version.isBlank() ? version : BiomeStep.defaultVersion();
        this.pathToExe = pathToExe;
        this.downloadDir = downloadDir;
    }

    public FormatterStep create() {
        return FormatterStep.createLazy(this.name(), this::createState, State::toFunc);
    }

    public BiomeStep withConfigPath(String configPath) {
        this.configPath = configPath;
        return this;
    }

    public BiomeStep withLanguage(String language) {
        this.language = language;
        return this;
    }

    private State createState() throws IOException, InterruptedException {
        String resolvedPathToExe = this.resolveExe();
        BiomeStep.validateBiomeExecutable(resolvedPathToExe);
        BiomeStep.validateBiomeConfigPath(this.configPath, this.version);
        LOGGER.debug("Using Biome executable located at  '{}'", (Object)resolvedPathToExe);
        FileSignature exeSignature = FileSignature.signAsList(new File(resolvedPathToExe));
        BiomeStep.makeExecutable(resolvedPathToExe);
        return new State(resolvedPathToExe, exeSignature, this.configPath, this.language);
    }

    private String resolveExe() throws IOException, InterruptedException {
        new ForeignExe();
        if (this.pathToExe != null) {
            if (Path.of(this.pathToExe, new String[0]).getNameCount() == 1) {
                return BiomeStep.resolveNameAgainstPath(this.pathToExe);
            }
            return this.pathToExe;
        }
        BiomeExecutableDownloader downloader = new BiomeExecutableDownloader(Path.of(this.downloadDir, new String[0]));
        String downloaded = downloader.ensureDownloaded(this.version).toString();
        BiomeStep.makeExecutable(downloaded);
        return downloaded;
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 6846790911054484379L;
        private final String pathToExe;
        private final FileSignature exeSignature;
        private final String configPath;
        private final String language;

        private State(String exe, FileSignature exeSignature, String configPath, String language) {
            this.pathToExe = exe;
            this.exeSignature = exeSignature;
            this.configPath = configPath;
            this.language = language;
        }

        private String[] buildBiomeCommand(File file) {
            String fileName = this.resolveFileName(file);
            ArrayList<String> argList = new ArrayList<String>();
            argList.add(this.pathToExe);
            argList.add("format");
            argList.add("--stdin-file-path");
            argList.add(fileName);
            if (this.configPath != null) {
                argList.add("--config-path");
                argList.add(this.configPath);
            }
            return (String[])argList.toArray(String[]::new);
        }

        private String format(ProcessRunner runner, String input, File file) throws IOException, InterruptedException {
            String formatted;
            ProcessRunner.Result runnerResult;
            String stdErr;
            byte[] stdin = input.getBytes(StandardCharsets.UTF_8);
            CharSequence[] args = this.buildBiomeCommand(file);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Running Biome command to format code: '{}'", (Object)String.join((CharSequence)", ", args));
            }
            if (!(stdErr = (runnerResult = runner.exec(stdin, (String[])args)).stdErrUtf8()).isEmpty()) {
                LOGGER.warn("Biome stderr ouptut for file '{}'\n{}", (Object)file, (Object)stdErr.trim());
            }
            if ((formatted = runnerResult.assertExitZero(StandardCharsets.UTF_8)).isEmpty()) {
                return input;
            }
            return formatted;
        }

        private String resolveFileName(File file) {
            String name = file.getName();
            if (this.language == null || this.language.isBlank()) {
                return name;
            }
            int dot = name.lastIndexOf(".");
            String ext = dot >= 0 ? name.substring(dot + 1) : name;
            switch (this.language) {
                case "js?": {
                    return "jsx".equals(ext) || "js".equals(ext) || "mjs".equals(ext) || "cjs".equals(ext) ? name : "file.js";
                }
                case "ts?": {
                    return "tsx".equals(ext) || "ts".equals(ext) || "mts".equals(ext) || "cts".equals(ext) ? name : "file.js";
                }
                case "js": {
                    return "js".equals(ext) || "mjs".equals(ext) || "cjs".equals(ext) ? name : "file.js";
                }
                case "jsx": {
                    return "jsx".equals(ext) ? name : "file.jsx";
                }
                case "ts": {
                    return "ts".equals(ext) || "mts".equals(ext) || "cts".equals(ext) ? name : "file.ts";
                }
                case "tsx": {
                    return "tsx".equals(ext) ? name : "file.tsx";
                }
                case "json": {
                    return "json".equals(ext) ? name : "file.json";
                }
                case "jsonc": {
                    return "jsonc".equals(ext) ? name : "file.jsonc";
                }
                case "css": {
                    return "css".equals(ext) ? name : "file.css";
                }
            }
            return "file." + this.language;
        }

        private FormatterFunc.Closeable toFunc() {
            ProcessRunner runner = new ProcessRunner();
            return FormatterFunc.Closeable.of(runner, this::format);
        }
    }
}

