/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

class RingBufferByteArrayOutputStream
extends ByteArrayOutputStream {
    private final int limit;
    private int zeroIndexPointer;
    private boolean isOverLimit;

    public RingBufferByteArrayOutputStream(int limit) {
        this(limit, 32);
    }

    public RingBufferByteArrayOutputStream(int limit, int initialCapacity) {
        super(initialCapacity);
        if (limit < initialCapacity) {
            throw new IllegalArgumentException("Limit must be greater than initial capacity. Limit: " + limit + ", initial capacity: " + initialCapacity);
        }
        if (limit < 2) {
            throw new IllegalArgumentException("Limit must be greater than or equal to 2 but is " + limit);
        }
        if (limit % 2 != 0) {
            throw new IllegalArgumentException("Limit must be an even number but is " + limit);
        }
        this.limit = limit;
    }

    @Override
    public synchronized void write(int b) {
        if (this.count < this.limit) {
            super.write(b);
            return;
        }
        this.isOverLimit = true;
        this.buf[this.zeroIndexPointer] = (byte)b;
        this.zeroIndexPointer = (this.zeroIndexPointer + 1) % this.limit;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        int remaining = this.limit - this.count;
        if (remaining >= len) {
            super.write(b, off, len);
            return;
        }
        if (remaining > 0) {
            super.write(b, off, remaining);
            this.write(b, off + remaining, len - remaining);
            return;
        }
        this.isOverLimit = true;
        int writeTillLimit = Math.min(len, this.limit - this.zeroIndexPointer);
        System.arraycopy(b, off, this.buf, this.zeroIndexPointer, writeTillLimit);
        this.zeroIndexPointer = (this.zeroIndexPointer + writeTillLimit) % this.limit;
        if (writeTillLimit < len) {
            this.write(b, off + writeTillLimit, len - writeTillLimit);
        }
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.zeroIndexPointer = 0;
        this.isOverLimit = false;
    }

    @Override
    public synchronized void writeTo(OutputStream out) throws IOException {
        if (!this.isOverLimit) {
            super.writeTo(out);
            return;
        }
        out.write(this.buf, this.zeroIndexPointer, this.limit - this.zeroIndexPointer);
        out.write(this.buf, 0, this.zeroIndexPointer);
    }

    @Override
    public synchronized byte[] toByteArray() {
        if (!this.isOverLimit) {
            return super.toByteArray();
        }
        byte[] result = new byte[this.limit];
        System.arraycopy(this.buf, this.zeroIndexPointer, result, 0, this.limit - this.zeroIndexPointer);
        System.arraycopy(this.buf, 0, result, this.limit - this.zeroIndexPointer, this.zeroIndexPointer);
        return result;
    }

    @Override
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="We want to use the default encoding here since this is contract on ByteArrayOutputStream")
    public synchronized String toString() {
        if (!this.isOverLimit) {
            return super.toString();
        }
        return new String(this.buf, this.zeroIndexPointer, this.limit - this.zeroIndexPointer) + new String(this.buf, 0, this.zeroIndexPointer);
    }

    @Override
    public synchronized String toString(String charsetName) throws UnsupportedEncodingException {
        if (!this.isOverLimit) {
            return super.toString(charsetName);
        }
        return new String(this.buf, this.zeroIndexPointer, this.limit - this.zeroIndexPointer, charsetName) + new String(this.buf, 0, this.zeroIndexPointer, charsetName);
    }
}

