/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.diktat.compat;

import com.diffplug.spotless.glue.diktat.compat.DiktatCompatAdapter;
import com.diffplug.spotless.glue.diktat.compat.DiktatReporting;
import com.saveourtool.diktat.DiktatFactoriesKt;
import com.saveourtool.diktat.DiktatProcessor;
import com.saveourtool.diktat.api.DiktatCallback;
import com.saveourtool.diktat.api.DiktatError;
import com.saveourtool.diktat.api.DiktatRuleConfig;
import com.saveourtool.diktat.api.DiktatRuleSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiktatCompat2Dot0Dot0Adapter
implements DiktatCompatAdapter {
    private final DiktatProcessor processor;
    private final DiktatCallback formatterCallback;
    private final ArrayList<DiktatError> errors = new ArrayList();

    public DiktatCompat2Dot0Dot0Adapter(@Nullable File configFile) {
        this.processor = DiktatCompat2Dot0Dot0Adapter.getDiktatReporter(configFile);
        this.formatterCallback = new FormatterCallback(this.errors);
    }

    @Override
    public String format(File file, String content, boolean isScript) {
        this.errors.clear();
        String result = this.processor.fix(content, file.toPath(), this.formatterCallback);
        DiktatReporting.reportIfRequired(this.errors, DiktatError::getLine, DiktatError::getRuleId, DiktatError::getDetail);
        return result;
    }

    private static DiktatProcessor getDiktatReporter(File configFile) {
        DiktatRuleSet ruleSet = DiktatFactoriesKt.getDiktatRuleSetFactory().invoke(DiktatCompat2Dot0Dot0Adapter.readRuleConfigs(configFile));
        return DiktatFactoriesKt.getDiktatProcessorFactory().invoke(ruleSet);
    }

    private static List<DiktatRuleConfig> readRuleConfigs(File configFile) {
        List list;
        if (configFile == null) {
            return Collections.emptyList();
        }
        FileInputStream configInputStream = new FileInputStream(configFile);
        try {
            list = DiktatFactoriesKt.getDiktatRuleConfigReader().invoke((InputStream)configInputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)configInputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Fail to read configFile", e);
            }
        }
        ((InputStream)configInputStream).close();
        return list;
    }

    private static class FormatterCallback
    implements DiktatCallback {
        private final ArrayList<DiktatError> errors;

        FormatterCallback(ArrayList<DiktatError> errors) {
            this.errors = errors;
        }

        public Unit invoke(DiktatError diktatError, Boolean corrected) {
            this.doInvoke(diktatError, corrected);
            return Unit.INSTANCE;
        }

        public void invoke(@NotNull DiktatError diktatError, boolean corrected) {
            this.doInvoke(diktatError, corrected);
        }

        private void doInvoke(@NotNull DiktatError diktatError, boolean corrected) {
            if (!corrected) {
                this.errors.add(diktatError);
            }
        }
    }
}

